% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSampleDCA.R
\name{getSampleDCA}
\alias{getSampleDCA}
\title{Get the Detrended correspondence Analysis (DCA) Score Value for A Single Sample}
\usage{
getSampleDCA(
  simSample,
  origAbundData,
  useTransformedRelAbundance = TRUE,
  projectIntoOrigDCA = TRUE,
  returnDCAforOrigAndSim = FALSE,
  whichAxes = 1,
  powerRootTransform = 1
)
}
\arguments{
\item{simSample}{The assemblage data for a single sample (presumably from a simulation).}

\item{origAbundData}{The original matrix of abundance data, to be used to
project the simulated data into the same detrended correspondence analysis (DCA) space.}

\item{useTransformedRelAbundance}{Should the DCA be analyzed}

\item{projectIntoOrigDCA}{Should the new simulated data be projected in the DCA generated by analyzing the original data? This is \code{TRUE} by default, which is what most users will likely use, as it is the preferable way to consider how the new simulated data relates to the original data.}

\item{returnDCAforOrigAndSim}{Should the DCA score values for both the new simulated data and the original abundance data be returned? Default is \code{FALSE} as projecting the new data into the original DCA space means the original data should never be meaningfully different the original score values.}

\item{whichAxes}{Which dimensional score from the DCA should be used? By default this is 1. Unclear under what circumstances one would ever use a value other than 1, though, as detrending the correspondence analysis causes distortion along all scores other than the first axis of the ordination. Only the first score can be returned when \code{projectIntoOrigDCA = TRUE}.}

\item{powerRootTransform}{The power-root transform to be used on the abundance data before applying the DCA. By default this is 1, which means the data is not transformed at all. Note that the power-root transform is only performed if \code{useTransformedRelAbundance = TRUE}.}
}
\value{
A vector, containing either a single value, the DCA score value of the simulated sample, when \code{returnDCAforOrigAndSim = FALSE}, or a vector of the DCA scores for the original data and
}
\description{
For a single simulated assemblage sample, projects its location in DCA space defined by the original abundance data.
}
\details{
Detrended correspondence analysis (DCA) is a common method 
for producing an ordination of ecological data. 
It isn't the only such method.
}
\seealso{
This function is ultimately just a wrapper for using \code{decorana} in package \code{vegan}.
}
