% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_panel.R
\name{panel_collect}
\alias{panel_collect}
\title{Collect a panel, from wide to long}
\usage{
panel_collect(data, cross.section = NULL, cross.section.columns = NULL,
  time.variable = NULL, time.variable.columns = NULL)
}
\arguments{
\item{data}{The panel to transform}

\item{cross.section}{The name of the transformed cross sectional variable supply as chracter.}

\item{cross.section.columns}{The names of the columns indicating cross sections to collect.}

\item{time.variable}{The name of the transformed time variable supply as character.}

\item{time.variable.columns}{The names of the columns indicating time variables to collect.}
}
\value{
A collected data.table, with new columns constructed by collecting from the wide format.
}
\description{
Transforms cross sectional/time dummies to unified variables
}
\details{
For time variables named like "Time_Var_i" with arbitrary i, the program will check that all time variables are named using this convention, and strip this convention
}
\examples{

x_1 <- rnorm( 10 )
cross_levels <- c( "AT", "DE" )
time <- seq(1:5)
time <- rep(time, 2)
geo_list <- list()
for(i in 1:length(cross_levels))
{
  geo <- rep( cross_levels[i],
                100 )
                  geo_list[[i]] <- geo
                  }
                  geo <- unlist(geo_list)
                  geo <- as.data.frame(geo)

 example_data <- cbind( time,
                       x_1 )
 example_data <- as.data.frame(example_data)

 example_data <- cbind( geo,
                       example_data)
 names(example_data) <- c("geo", "time", "x_1")

# generate dummies using panel_dummify()
 test_dummies <- panel_dummify( data = example_data,
                                cross.section = "geo",
                                time.variable = "time")
panel_collect( data = test_dummies,
               cross.section = "geo",
               cross.section.columns = c( "AT", "DE"))

}
