% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessModelQuality.R
\name{assessModelQuality}
\alias{assessModelQuality}
\title{Create randomly initialized models to determine the correct number of components by assessing model quality metrics.}
\usage{
assessModelQuality(
  X,
  minNumComponents = 1,
  maxNumComponents = 5,
  numRepetitions = 100,
  ctol = 1e-04,
  maxit = 500,
  numCores = 1
)
}
\arguments{
\item{X}{Input data}

\item{minNumComponents}{Minimum number of components (default 1).}

\item{maxNumComponents}{Maximum number of components (default 5).}

\item{numRepetitions}{Number of randomly initialized models to create (default 100).}

\item{ctol}{Relative change in loss tolerated to call the algorithm converged in the ALS case (default 1e-4).}

\item{maxit}{Maximum number of iterations allowed without convergence (default 500).}

\item{numCores}{Number of cores to use. If set larger than 1, it will run the job in parallel (default 1)}
}
\value{
A list object of the following:
\itemize{
\item plots: Plots of all assessed metrics and an overview plot showing a summary of all of them.
\item metrics: metrics of every created model (number of iterations, sum of squared errors, CORCONDIA score and variance explained).
\item models: all created models.
}
}
\description{
Create randomly initialized models to determine the correct number of components by assessing model quality metrics.
}
\examples{
X = Fujita2023$data

# Run assessModelQuality with less strict convergence parameters as example
assessment = assessModelQuality(X,
                                minNumComponents=1,
                                maxNumComponents=3,
                                numRepetitions=5)
assessment$plots$overview
}
