% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPedList.R
\name{plotPedList}
\alias{plotPedList}
\title{Plot a list of pedigrees.}
\usage{
plotPedList(
  plot.arg.list,
  widths = NA,
  frames = TRUE,
  frametitles = NULL,
  fmar = NA,
  newdev = FALSE,
  dev.height = NA,
  dev.width = NA,
  ...
)
}
\arguments{
\item{plot.arg.list}{A list of lists. Each element of \code{plot.arg.list} is
a list, where the first element is the \code{\link{linkdat}} object to be
plotted, and the remaining elements are passed on to \code{plot.linkdat}.
These elements must be correctly named. See examples below.}

\item{widths}{A numeric vector of relative widths of the subplots. Recycled
to \code{length(plot.arg.list)} if necessary, before passed on to
\code{\link{layout}}. Note that the vector does not need to sum to 1.}

\item{frames}{Either a single logical (FALSE = no frames; TRUE = automatic
framing) or a list of numeric vectors: Each vector must consist of
consecutive integers, indicating subplots to be framed together. By default
the framing follows the list structure of \code{plot.arg.list}.}

\item{frametitles}{A character vector of titles for each frame. If this is
non-NULL, titles for individuals subplots are ignored.}

\item{fmar}{A single number in the interval [0,0.5) controlling the position
of the frames.}

\item{newdev}{A logical, indicating if a new plot window should be opened.}

\item{dev.height, dev.width}{The dimensions of the new device (only relevant
if newdev is TRUE). If these are NA suitable values are guessed from the
pedigree sizes.}

\item{\dots}{Further arguments passed on to each call to
\code{\link{plot.linkdat}}.}
}
\description{
This function creates a row of pedigree plots, each created by
\code{\link{plot.linkdat}}.  Each parameter accepted by
\code{\link{plot.linkdat}} can be applied here.  Some effort is made to guess
a reasonable window size and margins, but in general the user must be
prepared to do manual resizing of the plot window.
}
\details{
See various examples in the Examples section below.

Note that for tweaking dev.height and dev.width the function
\code{\link{dev.size}} is useful to determine the size of the active device.
}
\examples{


# Simplest use: Just give a list of linkdat objects.
# To guess suitable plot window dimensions, use 'newdev=T'
peds = list(nuclearPed(3),cousinPed(2), singleton(12), halfCousinsPed(0))
plotPedList(peds) # try with newdev=TRUE

\dontrun{
# Modify the relative widths (which are not guessed)
widths = c(2, 3, 1, 2)
plotPedList(peds, widths=widths)

# In most cases the guessed dimensions are not perfect.
# Resize plot window manually, and then plot again with newdev=F (default)
# plotPedList(peds, widths=widths)

## Remove frames
plotPedList(peds, widths=widths, frames=F)

# Non-default frames
frames = list(1, 2:3)
plotPedList(peds, widths=widths, frames=frames, frametitles=c('First', 'Second'))

# To give *the same* parameter to all plots, it can just be added at the end:
margins=c(2,4,2,4)
title='Same title'
id.labels=''
symbolsize=1.5 # note: doesn't work as expected for singletons
plotPedList(peds, widths=widths, frames=frames, margins=margins, title=title,
            id.labels=id.labels, symbolsize=symbolsize)

# For more control of individual plots, each plot and all its parameters
# can be specified in its own list:
x1 = nuclearPed(3)
x1$available = 3:5
m1 = marker(x1, 3, 1:2)
marg1 = c(5,4,5,4)
plot1 = list(x1, marker=m1, margins=marg1, title='Plot 1', deceased=1:2)

x2 = cousinsPed(2)
x2$available = leaves(x2)
m2 = marker(x2, leaves(x2), 'A')
marg2 = c(3,4,2,4)
plot2 = list(x2, marker=m2, margins=marg2, title='Plot 2', symbolsize=1.2,
             skip.empty.genotypes=T)

x3 = singleton(12)
x3 = setAvailable(x3, 12)
marg3 = c(10,0,0,0)
plot3 = list(x3, margins=marg3, title='Plot 3', available='shaded', symbolsize=2)

x4 = halfCousinsPed(0)
names4 = c(Father=1, Brother=3, Sister=5)
marg4 = marg1
plot4 = list(x4, margins=marg4, title='Plot 4', id.labels=names4)

plotPedList(list(plot1, plot2, plot3, plot4), widths=c(2,3,1,2),
            frames=list(1,2:3,4), available=T, newdev=T)

# Different example:
plotPedList(list(halfCousinPed(4), cousinsPed(7)), title='Many generations',
    new=T, dev.height=9, dev.width=9)
}

}
\seealso{
\code{\link{plot.linkdat}}
}
