% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{options}
\alias{options}
\alias{find_bracket_options}
\alias{bracket_options}
\alias{bracket_options<-}
\alias{find_brace_options}
\alias{brace_options}
\alias{brace_options<-}
\title{Find or modify macro or environment options}
\usage{
find_bracket_options(items, which = 1L, start = 1L)

bracket_options(items, which = 1L, start = 1L)

bracket_options(items, which = 1, start = 1, asis = FALSE) <- value

find_brace_options(items, which = 1L, start = 1L, path = FALSE)

brace_options(items, which = 1, start = 1)

brace_options(items, which = 1, start = 1, asis = FALSE) <- value
}
\arguments{
\item{items}{A list of latex items.}

\item{which}{Which options do you want?  Some
macros support more than one set.}

\item{start}{Start looking at \code{items[[start]]}.
\code{start} may be a path.}

\item{asis}{Should newlines be added around the
value?}

\item{value}{The content to be inserted into the cell.  This
can be a \link{LaTeX2} object, or a character string that will be
converted to one.}

\item{path}{If \code{TRUE}, return a path rather than
an index, as with \code{\link[=find_general]{find_general()}},}
}
\value{
\code{find_bracket_options} returns a \link{LaTeX2range} object pointing to the options within \code{items} (including the
brackets).

\code{bracket_options} returns a \link{LaTeX2} object containing
the specified options.

\code{find_brace_options} returns the index
or path to the block containing the options.

\code{brace_options} returns a \link{LaTeX2} object containing
the specified options.
}
\description{
Many Latex environments and macros take optional parameters
wrapped in square brackets.  \code{find_bracket_options} finds those,
assuming they come immediately after the macro.

Some Latex environments and macros take optional parameters
wrapped in curly brackets (braces). \code{find_brace_options} finds those
if they immediately follow the environment or macro (and possibly
some bracketed options).
}
\examples{
parsed <- parseLatex("\\\\section[a]{b}")
macro <- find_macro(parsed, "\\\\section")
bracket_options(parsed, start = macro + 1)

bracket_options(parsed, start = macro + 1) <- "Short Title"
parsed

brace_options(parsed, start = macro + 1)

brace_options(parsed, start = macro + 1) <- "Long Title"
parsed

}
