% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableRow.R
\name{prepare_table}
\alias{prepare_table}
\alias{prepare_row}
\title{Split up a table by rows}
\usage{
prepare_table(table, do_cells = TRUE)

prepare_row(row)
}
\arguments{
\item{table}{A tabular-like environment to work with.}

\item{do_cells}{Should the rows be prepared too?}

\item{row}{A list of items from a single row of a table.}
}
\value{
A \link{LaTeX2item} object which is the same table
but with the contents divided into \link{ITEMLIST}s.  The first element is an \link{ITEMLIST}
holding everything before the first row, then
each row is in its own \link{ITEMLIST}, and finally
one more holding everything after the last row. The attribute
\code{has_itemlists} will be set to \code{TRUE}.

\code{prepare_row()} returns a \link{LaTeX2item} object which is the same row
with \link{ITEMLIST}s holding the cells.  The attribute
\code{has_itemlist} will be set to \code{TRUE}.  The first
list will be the "extras" at the start of the row;
each cell will be in the following \link{ITEMLIST}s.
The following cell delimiter will be included in the cell.
}
\description{
Split up a table by rows
}
\examples{
latex <- kableExtra::kbl(mtcars[1:2, 1:2], format = "latex")
parsed <- parseLatex(latex)
table <- prepare_table(parsed[[find_tabular(parsed)]])
print(latex2(table), tags = TRUE)
row <- prepare_row(tableRow(table, 2))
print(latex2(row), tags = TRUE)
}
