% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tables}
\alias{tables}
\alias{is_tabular}
\alias{find_tabular}
\title{Functions related to parsing LaTeX tables}
\usage{
is_tabular(item)

find_tabular(items, start = 1)
}
\arguments{
\item{item}{An item from a \link{LaTeX2} list object.}

\item{items}{A \link{LaTeX2} list object.}

\item{start}{Where to start looking.}
}
\value{
\code{is_tabular()} returns boolean indicating if this is
a tabular-like environment.

\code{find_tabular()} returns the index of the first
tabular-like environment, or \code{NA} if none is found.
}
\description{
Functions related to parsing LaTeX tables
}
\examples{
latex <- kableExtra::kbl(mtcars[1:2, 1:2], format = "latex")
parsed <- parseLatex(latex)
is_tabular(parsed[[2]])


find_tabular(parsed)
table <- parsed[[find_tabular(parsed)]]
table

}
