% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_based.R
\name{classificationErrorDistance}
\alias{classificationErrorDistance}
\alias{classificationErrorDistance,Partition,Partition-method}
\title{Classification Error Distance}
\usage{
classificationErrorDistance(p, q)

\S4method{classificationErrorDistance}{Partition,Partition}(p, q)
}
\arguments{
\item{p}{The partition \eqn{P}}

\item{q}{The partition \eqn{Q}}
}
\description{
Compute the classification error distance
\deqn{1 - \frac{1}{n} \max_{\sigma}{\sum_{C \in \cal{P}}{|C \cap \sigma(C)|}}}
with \eqn{\sigma} a weighted matching between the clusters of both partitions.
The nodes are the classes of each partition, the weights are the overlap of objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{classificationErrorDistance(p = Partition, q = Partition)}: Compute given two partitions

}}
\section{Hint}{

This measure is implemented using \code{\link[lpSolve]{lp.assign}} from
the \code{lpSolve} package to compute the maxmimal matching of a 
weighted bipartite graph.
}

\examples{
isTRUE(all.equal(classificationErrorDistance(new("Partition", c(0, 0, 0, 1, 1)), 
                                             new("Partition", c(0, 0, 1, 1, 1))), 0.2))

}
\references{
\insertRef{Meila2001}{partitionComparison}

\insertRef{Meila2005}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
