% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_data_sources}
\alias{datazone_list_data_sources}
\title{Lists data sources in Amazon DataZone}
\usage{
datazone_list_data_sources(
  connectionIdentifier = NULL,
  domainIdentifier,
  environmentIdentifier = NULL,
  maxResults = NULL,
  name = NULL,
  nextToken = NULL,
  projectIdentifier,
  status = NULL,
  type = NULL
)
}
\arguments{
\item{connectionIdentifier}{The ID of the connection.}

\item{domainIdentifier}{[required] The identifier of the Amazon DataZone domain in which to list the data
sources.}

\item{environmentIdentifier}{The identifier of the environment in which to list the data sources.}

\item{maxResults}{The maximum number of data sources to return in a single call to
\code{\link[=datazone_list_data_sources]{list_data_sources}}. When the number of
data sources to be listed is greater than the value of \code{MaxResults}, the
response contains a \code{NextToken} value that you can use in a subsequent
call to \code{\link[=datazone_list_data_sources]{list_data_sources}} to list the
next set of data sources.}

\item{name}{The name of the data source.}

\item{nextToken}{When the number of data sources is greater than the default value for
the \code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of data sources, the response
includes a pagination token named \code{NextToken}. You can specify this
\code{NextToken} value in a subsequent call to
\code{\link[=datazone_list_data_sources]{list_data_sources}} to list the next set
of data sources.}

\item{projectIdentifier}{[required] The identifier of the project in which to list data sources.}

\item{status}{The status of the data source.}

\item{type}{The type of the data source.}
}
\description{
Lists data sources in Amazon DataZone.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_data_sources/} for full documentation.
}
\keyword{internal}
