\name{plot.pblm}
\alias{plot.pblm}

\title{
Plotting terms for a \code{pblm} object
}
\description{
Plotting fixed or smooth terms for a \code{pblm} object
}
\usage{
\method{plot}{pblm}(x, which.eq=1:3, which.var=1:x$maxNpred, add.bands=TRUE,
                    type="l",col.line=list("blue"), col.bands=NULL, 
                    dashed.bands=FALSE, pause = FALSE, ylim, xlim, ylab, xlab, 
                    main, overlaid_pvc=TRUE,...)
}


\arguments{
  \item{x}{An object of class \code{pblm}.}
  \item{which.var}{Index of the smoother term, indicating its position in the model formula.}
  \item{which.eq}{Equation index identifying the component (marginal or association) where the smoother is applied.}
  \item{add.bands}{Logical. Should confidence bands for the smoother be added to the plot?}
  \item{col.bands}{Color to be used for the confidence bands.}
  \item{col.line}{Color to be used for the smoother line. Different colors are allowed when using \code{pvc()}.}
  \item{type}{Graphical parameter specifying the plot type.}
  \item{dashed.bands}{Logical. If \code{TRUE} (and \code{add.bands} is also \code{TRUE}), dashed confidence bands will be drawn instead of filled color bands.}
  \item{pause}{Logical. If \code{TRUE}, the user will be prompted to press a key before each plot is displayed.}
  \item{ylim}{Graphical parameter defining the limits of the y-axis.}
  \item{xlim}{Graphical parameter defining the limits of the x-axis.}
  \item{ylab}{Graphical parameter specifying the label for the y-axis.}
  \item{xlab}{Graphical parameter specifying the label for the x-axis.}
  \item{main}{Graphical parameter specifying the main title of the plot.}
  \item{overlaid_pvc}{Logical. Under development, currently ignored.}
  \item{\dots}{Further graphical parameters to be passed to the plotting functions.}
}
\details{
This function works similarly to the \code{termplot} function for many statistical models,
and is based on the \code{\link{predict}} method. The argument \code{overlaid_pvc}
is currently ignored because, although implemented, the smoother function \code{pvc()} for fitting
penalized varying coefficient models is still experimental and not included in this
version of the package. 

}
\value{
Returns the plots of the partial effects for the terms specified in the model formula,  
or for a specific term identified by \code{which.equation} and \code{which.term}.  

In addition, a variable-length list is returned, containing one object for each term included  
in the model formula or selected via \code{which.equation} and \code{which.term}.  
Each object is named by concatenating the equation type and the term name, and consists of  
a data frame with as many rows as the original dataset and four columns:  
the x-axis values, the y-axis values, the 95\% lower bounds, and the 95\% upper bounds.  

For example, consider a variable named \code{v} included in the model for both marginals and the association.  
The returned list would include:

  \item{mar1:v}{A data frame containing the plotting data for variable \code{v} in the first marginal.}
  \item{mar2:v}{A data frame containing the plotting data for variable \code{v} in the second marginal.}
  \item{ass12:v}{A data frame containing the plotting data for variable \code{v} in the association component.}
  \item{\dots}{Additional data frames, depending on the number of terms involved.}
}
\author{
Marco Enea
}
\seealso{
\code{\link{pb}}, \code{\link{pbs}}
}
\examples{
#NOT RUN 
# an artificial data set: 
set.seed(123)
da <- expand.grid("Y1"=1:3,"Y2"=1:3,"v1"=0:4,"fat2"=0:1)
da$Freq <- sample(0:20,3*3*5*2,replace=TRUE)
da$x1 <- rnorm(90)
#the bivariate additive proportional-odds model
m7 <- pblm(fo1=cbind(Y1,Y2) ~ v1 + fat2 + pb(x1), data=da, weights=Freq)
plot(m7)
}
\keyword{ multivariate }
\keyword{ regression }
\keyword{ models }
\keyword{ nonparametric }
\keyword{ smooth }
