% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfactor_interpret_kr.R
\name{bfactor_interpret_kr}
\alias{bfactor_interpret_kr}
\title{Interpretation of Bayes factors}
\usage{
bfactor_interpret_kr(bf)
}
\arguments{
\item{bf}{A numeric vector of non-negative values.}
}
\value{
Returns a character vector with the same \code{\link[base]{length}} as \code{bf}.
}
\description{
Quantify the strength of the evidence provided by the data to a model/hypothesis according a Bayes factor interpretation scale suggested by \insertCite{kass1995;textual}{pcal}.
}
\details{
Bayes factors are a summary of the evidence provided by the data to a model/hypothesis. Because it can be useful to consider twice the natural logarithm of the Bayes factor, which is in the same scale as the familiar deviance and likelihood ratio test statistics, \insertCite{kass1995;textual}{pcal} suggested the following Bayes factor interpretation scale:\tabular{lll}{
   \strong{2*log(Bayes factor)} \tab \strong{Bayes factor} \tab \strong{Evidence} \cr
   [-Inf, 0[ \tab [0, 1[ \tab Negative \cr
   [0, 2[ \tab [1, 3[ \tab Weak \cr
   [2, 6[ \tab [3, 20[ \tab Positive \cr
   [6, 10[ \tab [20, 150[ \tab Strong \cr
   [10, +Inf[ \tab [150, +Inf[ \tab Very strong \cr
}


\code{bfactor_interpret_kr} takes Bayes factors as input and returns the strength of the evidence in favor of the model/hypothesis in the numerator of the Bayes factors (usually the null hypothesis) according to the aforementioned table.

When comparing results with those from standard likelihood ratio tests, it is convenient to put the null hypothesis in the denominator of the Bayes factor so that \code{bfactor_interpret_kr} returns the strength of the evidence against the null hypothesis. If \code{bf} was obtained with the null hypothesis on the numerator, one can use \code{bfactor_interpret_kr(1/bf)} to obtain the strength of the evidence against the null hypothesis.
}
\examples{
# Interpretation of one Bayes factor
bfactor_interpret_kr(1.5)

# Interpretation of many Bayes factors
bfactor_interpret_kr(c(0.1, 1.2, 3.5, 13.9, 150))

# Application: chi-squared goodness-of-fit test.
# Strength of the evidence provided by the lower
# bound on the Bayes factor in favor of the null hypothesis:
x <- matrix(c(12, 15, 14, 15), ncol = 2)
bfactor_interpret_kr(bcal(chisq.test(x)[["p.value"]]))

}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[pcal]{bfactor_interpret}} for the original interpretation scale suggested by Harold Jeffreys.
\item \code{\link[pcal]{bfactor_log_interpret}} and \code{\link[pcal]{bfactor_log_interpret_kr}} for the interpretation of the logarithms of Bayes factors.
\item \code{\link[pcal]{bfactor_to_prob}} to turn Bayes factors into posterior probabilities.
\item \code{\link[pcal]{bcal}} for a p-value calibration that returns lower bounds on Bayes factors in favor of point null hypotheses.
}
}
