% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{Idom.num1CSstd.tri}
\alias{Idom.num1CSstd.tri}
\title{The indicator for a point being a dominating point for Central Similarity Proximity Catch Digraphs
(CS-PCDs) - standard equilateral triangle case}
\usage{
Idom.num1CSstd.tri(p, Xp, t, ch.data.pnt = FALSE)
}
\arguments{
\item{p}{A 2D point that is to be tested for being a dominating point or not of the CS-PCD.}

\item{Xp}{A set of 2D points which constitutes the vertices of the CS-PCD.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{ch.data.pnt}{A logical argument for checking whether point \code{p} is a data point
in \code{Xp} or not (default is \code{FALSE}).}
}
\value{
\eqn{I(}\code{p} is a dominating point of the CS-PCD\eqn{)} where the vertices of the CS-PCD are the 2D data set \code{Xp},
that is, returns 1 if \code{p} is a dominating point, returns 0 otherwise
}
\description{
Returns \eqn{I(}\code{p} is a dominating point of the CS-PCD\eqn{)} where the vertices of the CS-PCD are the 2D data set \code{Xp} in the standard equilateral
triangle \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))}, that is, returns 1 if \code{p} is a dominating point of CS-PCD,
returns 0 otherwise.

CS proximity region is constructed with respect to \eqn{T_e} with expansion parameter \eqn{t>0}
and edge regions are based on center of mass \eqn{CM=(1/2,\sqrt{3}/6)}.

\code{ch.data.pnt} is for checking whether point \code{p} is a data point in \code{Xp} or not (default is \code{FALSE}), so by default this
function checks whether the point \code{p} would be a dominating point if it actually were in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\donttest{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
CM<-(A+B+C)/3
Te<-rbind(A,B,C);
t<-1.5
n<-10  #try also n<-20

set.seed(1)
Xp<-runif.std.tri(n)$gen.points

Idom.num1CSstd.tri(Xp[3,],Xp,t)
Idom.num1CSstd.tri(c(1,2),c(1,2),t)
Idom.num1CSstd.tri(c(1,2),c(1,2),t,ch.data.pnt = TRUE)

gam.vec<-vector()
for (i in 1:n)
{gam.vec<-c(gam.vec,Idom.num1CSstd.tri(Xp[i,],Xp,t))}

ind.gam1<-which(gam.vec==1)
ind.gam1

Xlim<-range(Te[,1],Xp[,1])
Ylim<-range(Te[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Te,pch=".",xlab="",ylab="",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Te)
points(Xp)
L<-Te; R<-matrix(rep(CM,3),ncol=2,byrow=TRUE);
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
points(rbind(Xp[ind.gam1,]),pch=4,col=2)
#rbind is to insert the points correctly if there is only one dominating point

txt<-rbind(Te,CM)
xc<-txt[,1]+c(-.02,.02,.01,.05)
yc<-txt[,2]+c(.02,.02,.03,.02)
txt.str<-c("A","B","C","CM")
text(xc,yc,txt.str)

Idom.num1CSstd.tri(c(1,2),Xp,t,ch.data.pnt = FALSE)
#gives an error if ch.data.pnt = TRUE message since p is not a data point
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Idom.num1CSt1std.tri}}
}
\author{
Elvan Ceyhan
}
