% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{funsAB2MTe}
\alias{funsAB2MTe}
\alias{lineA2MinTe}
\alias{lineB2MinTe}
\alias{lineC2MinTe}
\title{The lines joining the three vertices of
the standard equilateral triangle to a center, \code{M}, of it}
\usage{
lineA2MinTe(x, M)

lineB2MinTe(x, M)

lineC2MinTe(x, M)
}
\arguments{
\item{x}{A single scalar or a \code{vector} of scalars.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center
in the interior of the standard equilateral triangle.}
}
\value{
A \code{list} with the elements
\item{txt1}{Longer description of the line.}
\item{txt2}{Shorter description of the line
(to be inserted over the line in the plot).}
\item{mtitle}{The \code{"main"} title for the plot of the line.}
\item{cent}{The center chosen inside the standard equilateral triangle.}
\item{cent.name}{The name of the center
inside the standard equilateral triangle.}
\item{tri}{The triangle
(it is the standard equilateral triangle for this function).}
\item{x}{The input vector, can be a scalar
or a \code{vector} of scalars,
which constitute the \eqn{x}-coordinates of the point(s) of interest
on the line.}
\item{y}{The output vector,
will be a scalar if \code{x} is a scalar
or a \code{vector} of scalars if \code{x} is
a \code{vector} of scalar,
constitutes the \eqn{y}-coordinates of the point(s) of interest on the line.}
\item{slope}{Slope of the line.}
\item{intercept}{Intercept of the line.}
\item{equation}{Equation of the line.}
}
\description{
Three functions, \code{lineA2MinTe}, \code{lineB2MinTe} and \code{lineC2MinTe}
of class \code{"TriLines"}.
Returns the \code{equation, slope, intercept},
and \eqn{y}-coordinates of the lines joining \eqn{A} and \code{M},
\eqn{B} and \code{M}, and also \eqn{C} and \code{M}.

\code{lineA2MinTe} is the line joining \eqn{A} to the center, \code{M},
\code{lineB2MinTe} is the line joining \eqn{B} to \code{M},
and \code{lineC2MinTe} is the line joining C to \code{M},
in the standard equilateral triangle \eqn{T_e=(A,B,C)}
with \eqn{A=(0,0)}, \eqn{B=(1,0)}, \eqn{C=(1/2,\sqrt{3}/2)};
\eqn{x}-coordinates are provided in \code{vector} \code{x}
}
\examples{
\donttest{
#Examples for lineA2MinTe
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)

M<-c(.65,.2)  #try also M<-c(1,1,1)

xfence<-abs(A[1]-B[1])*.25
#how far to go at the lower and upper ends in the x-coordinate
x<-seq(min(A[1],B[1])-xfence,max(A[1],B[1])+xfence,by = .1)  #try also by = .01

lnAM<-lineA2MinTe(x,M)
lnAM
summary(lnAM)
plot(lnAM)

Ds<-prj.cent2edges(Te,M)
#finds the projections from a point M=(m1,m2) to the edges on the
#extension of the lines joining M to the vertices in the triangle Te

Xlim<-range(Te[,1])
Ylim<-range(Te[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Te,pch=".",xlab="",ylab="",
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Te)
L<-Te; R<-rbind(M,M,M)
segments(L[,1], L[,2], R[,1], R[,2], lty = 2)
L<-Ds; R<-rbind(M,M,M)
segments(L[,1], L[,2], R[,1], R[,2], lty = 3,col=2)

txt<-rbind(Te,M,Ds,c(.25,lineA2MinTe(.25,M)$y),c(.4,lineB2MinTe(.4,M)$y),
c(.60,lineC2MinTe(.60,M)$y))
xc<-txt[,1]+c(-.02,.02,.02,.02,.04,-.03,.0,0,0,0)
yc<-txt[,2]+c(.02,.02,.02,.05,.02,.03,-.03,0,0,0)
txt.str<-c("A","B","C","M","D1","D2","D3","lineA2MinTe(x)","lineB2MinTe(x)","lineC2MinTe(x)")
text(xc,yc,txt.str)

lineA2MinTe(.25,M)
}

\donttest{
#Examples for lineB2MinTe
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)

M<-c(.65,.2)  #try also M<-c(1,1,1)

xfence<-abs(A[1]-B[1])*.25
#how far to go at the lower and upper ends in the x-coordinate
x<-seq(min(A[1],B[1])-xfence,max(A[1],B[1])+xfence,by = .5)  #try also by = .1

lnBM<-lineB2MinTe(x,M)
lnBM
summary(lnBM)
plot(lnBM)
}

\donttest{
#Examples for lineC2MinTe
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)

M<-c(.65,.2)  #try also M<-c(1,1,1)

xfence<-abs(A[1]-B[1])*.25
#how far to go at the lower and upper ends in the x-coordinate
x<-seq(min(A[1],B[1])-xfence,max(A[1],B[1])+xfence,by = .5)
#try also by = .1

lnCM<-lineC2MinTe(x,M)
lnCM
summary(lnCM)
plot(lnCM)
}

}
\seealso{
\code{\link{lineA2CMinTe}} and \code{\link{lineB2CMinTe}}
}
