% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{num.arcsPEint}
\alias{num.arcsPEint}
\title{Number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs)
and quantities related to the interval - one interval case}
\usage{
num.arcsPEint(Xp, int, r, c = 0.5)
}
\arguments{
\item{Xp}{A set of 1D points which constitute the vertices of PE-PCD.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
A \code{list} with the elements
\item{desc}{A short description of the output: number of arcs
and quantities related to the interval}
\item{num.arcs}{Total number of arcs in all intervals (including the end-intervals),
i.e., the number of arcs for the entire PE-PCD}
\item{num.in.range}{Number of \code{Xp} points in the interval \code{int}}
\item{num.in.ints}{The vector of number of \code{Xp} points in the partition intervals (including the end-intervals)}
\item{int.num.arcs}{The \code{vector} of the number of arcs of the components of the PE-PCD in the
partition intervals (including the end-intervals)}
\item{data.int.ind}{A \code{vector} of indices of partition intervals in which data points reside.
Partition intervals are numbered from left to right with 1 being the left end-interval.}
\item{ind.left.end, ind.mid, ind.right.end}{Indices of data points in the left end-interval,
middle interval, and right end-interval (respectively)}
\item{tess.points}{Tessellation points, i.e., points on which the tessellation of
the study region is performed,
here, tessellation points are the end points of the support interval \code{int}.}
\item{vertices}{Vertices of the digraph, \code{Xp}.}
}
\description{
An object of class \code{"NumArcs"}.
Returns the number of arcs of Proportional Edge Proximity Catch Digraph (PE-PCD)
whose vertices are the
data points in \code{Xp} in the one middle interval case.
It also provides number of vertices
(i.e., number of data points inside the intervals)
and indices of the data points that reside in the intervals.

The data points could be inside or outside the interval is \code{int}\eqn{=(a,b)}.
PE proximity region is constructed
with an expansion parameter \eqn{r \ge 1} and a centrality parameter \eqn{c \in (0,1)}.
\code{int} determines the end points of the interval.

The PE proximity region is constructed for both points inside and outside the interval,
hence
the arcs may exist for all points inside or outside the interval.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
\donttest{
c<-.4
r<-2
a<-0; b<-10; int<-c(a,b)

xf<-(int[2]-int[1])*.1

set.seed(123)

n<-10
Xp<-runif(n,a-xf,b+xf)
Narcs = num.arcsPEint(Xp,int,r,c)
Narcs
summary(Narcs)
plot(Narcs)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{num.arcsPEmid.int}}, \code{\link{num.arcsPEend.int}},
and \code{\link{num.arcsCSint}}
}
\author{
Elvan Ceyhan
}
