% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{plotASregs.tri}
\alias{plotASregs.tri}
\title{The plot of the Arc Slice (AS) Proximity Regions for a 2D data set - one triangle case}
\usage{
plotASregs.tri(
  Xp,
  tri,
  M = "CC",
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  vert.reg = FALSE,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points for which AS proximity regions are constructed.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or a 3D point in
barycentric coordinates which serves as a center in the interior of the triangle \eqn{T_b};
default is \code{M="CC"} i.e., the circumcenter of \code{tri}.}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab}{Titles for the \eqn{x} and \eqn{y} axes, respectively (default=\code{NULL} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2, giving the \eqn{x}- and \eqn{y}-coordinate ranges
(default=\code{NULL} for both).}

\item{vert.reg}{A logical argument to add vertex regions to the plot, default is \code{vert.reg=FALSE}.}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
Plot of the AS proximity regions for points inside the triangle \code{tri} (and only the points outside \code{tri})
}
\description{
Plots the points in and outside of the triangle \code{tri} and also the AS proximity regions
for points in data set \code{Xp}.

AS proximity regions are defined with respect to the triangle \code{tri},
so AS proximity regions are defined only for points inside the triangle \code{tri} and
vertex regions are based on the center, \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri}
or based on circumcenter of  \code{tri};
default is \code{M="CC"}, i.e., circumcenter of \code{tri}.
When vertex regions are constructed with circumcenter, \code{CC},
the vertex regions are constructed based on the
orthogonal projections to the edges, while with any interior center \code{M},
the vertex regions are constructed using the extensions
of the lines combining vertices with \code{M}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp0<-runif.tri(n,Tr)$g
M<-as.numeric(runif.tri(1,Tr)$g)  #try also  #M<-c(1.6,1.2);

plotASregs.tri(Xp0,Tr,M,main="Proximity Regions for AS-PCD", xlab="",ylab="")
Xp = Xp0[1,]
plotASregs.tri(Xp,Tr,M,main="Proximity Regions for AS-PCD", xlab="",ylab="")

#can plot the arcs of the AS-PCD
#plotASarcs.tri(Xp,Tr,M,main="Arcs of AS-PCD",xlab="",ylab="")

plotASregs.tri(Xp,Tr,M,main="Proximity Regions for AS-PCD", xlab="",ylab="",vert.reg=TRUE)

# or try the default center
#plotASregs.tri(Xp,Tr,main="Proximity Regions for AS-PCD", xlab="",ylab="",vert.reg=TRUE);
M = (arcsAStri(Xp,Tr)$param)$c #the part "M = as.numeric(arcsAStri(Xp,Tr)$param)" is optional,
#for the below annotation of the plot

#can add vertex labels and text to the figure (with vertex regions)
#but first we need to determine whether the center used for vertex regions is CC or not
#see the description for more detail.
CC<-circumcenter.tri(Tr)
#Arcs<-arcsAStri(Xp,Tr,M)
#M = as.numeric(Arcs$parameters)
if (isTRUE(all.equal(M,CC)) || identical(M,"CC"))
{cent<-CC
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)
cent.name<-"CC"
} else
{cent<-M
cent.name<-"M"
Ds<-prj.cent2edges(Tr,M)
}

#now we add the vertex names and annotation
txt<-rbind(Tr,cent,Ds)
xc<-txt[,1]+c(-.02,.03,.03,.03,.05,-0.03,-.01)
yc<-txt[,2]+c(.02,.02,.02,.07,.02,.05,-.06)
txt.str<-c("A","B","C",cent.name,"D1","D2","D3")
text(xc,yc,txt.str)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotASregs}}, \code{\link{plotPEregs.tri}}, \code{\link{plotPEregs}},
\code{\link{plotCSregs.tri}}, and \code{\link{plotCSregs}}
}
\author{
Elvan Ceyhan
}
