% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatternGen.R
\name{rseg.std.tri}
\alias{rseg.std.tri}
\title{Generation of points segregated (in a Type I fashion)
from the vertices of \eqn{T_e}}
\usage{
rseg.std.tri(n, eps)
}
\arguments{
\item{n}{A positive integer
representing the number of points to be generated.}

\item{eps}{A positive real number
representing the parameter of type I segregation (which is the
height of the triangular forbidden regions around the vertices).}
}
\value{
A \code{list} with the elements
\item{type}{The type of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{parameters}{The exclusion parameter, \code{eps},
of the segregation pattern, which is the height
of the triangular forbidden regions around the vertices }
\item{ref.points}{The input set of points \code{Y};
reference points, i.e., points
from which generated points are segregated
(i.e., vertices of \eqn{T_e}).}
\item{gen.points}{The output set of generated points segregated
from \code{Y} points (i.e., vertices of \eqn{T_e}).}
\item{tri.Y}{Logical output for triangulation
based on \code{Y} points should be implemented or not.
if \code{TRUE} triangulation based on \code{Y} points is
to be implemented (default is set to \code{FALSE}).}
\item{desc.pat}{Description of the point pattern}
\item{num.points}{The \code{vector} of two numbers,
which are the number of generated points and
the number of reference (i.e., \code{Y}) points, which is 3 here.}
\item{xlimit,ylimit}{The ranges of the \eqn{x}-
and \eqn{y}-coordinates of the reference points,
which are the vertices of \eqn{T_e} here.}
}
\description{
An object of class \code{"Patterns"}.
Generates \code{n} points uniformly
in the standard equilateral triangle
\eqn{T_e=T((0,0),(1,0),(1/2,\sqrt{3}/2))}
under the type I segregation alternative for \code{eps}
in \eqn{(0,\sqrt{3}/3=0.5773503]}.

In the type I segregation, the triangular forbidden regions
around the vertices are determined by
the parameter \code{eps}
which serves as the height of these triangles
(see examples for a sample plot.)

See also (\insertCite{ceyhan:arc-density-PE,ceyhan:arc-density-CS,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
\donttest{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C);
n<-100
eps<-.3  #try also .15, .5, .75

set.seed(1)
Xdt<-rseg.std.tri(n,eps)
Xdt
summary(Xdt)
plot(Xdt,asp=1)

Xlim<-range(Te[,1])
Ylim<-range(Te[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

Xp<-Xdt$gen.points

plot(Te,asp=1,pch=".",xlab="",ylab="",
main="Type I segregation in the \n standard equilateral triangle",
     xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01))
polygon(Te)
points(Xp)

#The support for the Type I segregation alternative
sr<-eps/(sqrt(3)/2)
C1<-C+sr*(A-C); C2<-C+sr*(B-C)
A1<-A+sr*(B-A); A2<-A+sr*(C-A)
B1<-B+sr*(A-B); B2<-B+sr*(C-B)
supp<-rbind(A1,B1,B2,C2,C1,A2)

plot(Te,asp=1,pch=".",xlab="",ylab="",
main="Support of the Type I Segregation",
     xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01))
if (sr<=.5)
{
  polygon(Te)
  polygon(supp,col=5)
} else
{
  polygon(Te,col=5,lwd=2.5)
  polygon(rbind(A,A1,A2),col=0,border=NA)
  polygon(rbind(B,B1,B2),col=0,border=NA)
  polygon(rbind(C,C1,C2),col=0,border=NA)
}
points(Xp)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rseg.circular}}, \code{\link{rassoc.circular}},
\code{\link{rsegII.std.tri}}, and \code{\link{rseg.multi.tri}}
}
\author{
Elvan Ceyhan
}
