% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{PcevObj}
\alias{PcevObj}
\alias{PcevClassical}
\alias{PcevBlock}
\alias{PcevSingular}
\title{Constructor functions for the different pcev objects}
\usage{
PcevClassical(response, covariate, confounder)

PcevBlock(response, covariate, confounder)

PcevSingular(response, covariate, confounder)
}
\arguments{
\item{response}{A matrix of response variables.}

\item{covariate}{A matrix or a data frame of covariates.}

\item{confounder}{A matrix or data frame of confounders}
}
\value{
A pcev object, of the class that corresponds to the estimation 
  method. These objects are lists that contain the data necessary for
  computation.
}
\description{
\code{PcevClassical}, \code{PcevBlock} and \code{PcevSingular} create the pcev objects from the 
provided data that are necessary to compute the PCEV according to the user's 
parameters.
}
\seealso{
\code{\link{estimatePcev}}, \code{\link{computePCEV}}
}
