% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.default.lambda.R
\name{find.default.lambda}
\alias{find.default.lambda}
\title{Default values for L1 penalty in conditional logistic regression}
\usage{
find.default.lambda(
  response,
  stratum,
  penalized,
  unpenalized = NULL,
  alpha = 1,
  p = NULL,
  standardize = TRUE,
  event,
  pf.list = NULL,
  nfolds = 10
)
}
\arguments{
\item{response}{The response variable, either a 0/1 vector or a factor with two levels.}

\item{stratum}{A numeric vector with stratum membership of each observation.}

\item{penalized}{A matrix of penalized covariates.}

\item{unpenalized}{A matrix of additional unpenalized covariates.}

\item{alpha}{The elastic net mixing parameter, a number between 0 and 1.
alpha=0 would give pure ridge; alpha=1 gives lasso. Pure ridge penalty is never obtained in this implementation since alpha must be positive.}

\item{p}{The sizes of blocks of covariates,
a numerical vector of the length equal to the number of blocks,
and with the sum equal to the number of penalized covariates.
If missing, all covariates are treated the same and a single penalty is applied.}

\item{standardize}{Should the covariates be standardized, a logical value.}

\item{event}{If response is a factor, the level that
should be considered a success in the logistic regression.}

\item{pf.list}{List of vectors of penalty factors.}

\item{nfolds}{The number of folds used in cross-validation. Default is 10.}
}
\value{
A single numeric value if \code{p} and \code{pf.list} are missing, or a list of numeric values
with L1 penalties for each vector of penalty factors supplied.
}
\description{
Performs cross validation to determine reasonable values for L1 penalty
in a conditional logistic regression.
}
\details{
The function is based on cross-validation implemented in the \code{clogitL1} package and returns
the value of \code{lambda} that minimizes cross validated deviance.
In the presence of blocks of covariates, a user specifies a list of
candidate vectors of penalty factors. For each candidate vector of penalty factors a
single \code{lambda} value is obtained.  Note that
cross-validation includes random data splitting, meaning
that obtained values can vary significantly between different runs.
}
\examples{
set.seed(123)
# simulate covariates (pure noise in two blocks of 20 and 80 variables)
X <- cbind(matrix(rnorm(4000, 0, 1), ncol = 20), matrix(rnorm(16000, 2, 0.6), ncol = 80))
p <- c(20,80)
pf.list <- list(c(0.5, 1), c(2, 0.9))
# stratum membership
stratum <- sort(rep(1:100, 2))

# the response
Y <- rep(c(1, 0), 100)

# obtain a list with vectors of penalty factors
\donttest{
lambda.list <- find.default.lambda(response = Y,
                                   penalized = X, stratum = stratum, p = p, pf.list = pf.list)}

# when `p` and `pf.list` are not provided all covariates are treated as a single block
\donttest{
lambda <- find.default.lambda(response = Y,
                                   penalized = X, stratum = stratum)}
}
\seealso{
\link{default.pf}
}
