% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stable.clr.R
\name{stable.clr}
\alias{stable.clr}
\title{Stability selection based on penalized conditional logistic regression}
\usage{
stable.clr(
  response,
  stratum,
  penalized,
  unpenalized = NULL,
  lambda.seq,
  alpha = 1,
  B = 100,
  parallel = TRUE,
  standardize = TRUE,
  event
)
}
\arguments{
\item{response}{The response variable, either a 0/1 vector or a factor with two levels.}

\item{stratum}{A numeric vector with stratum membership of each observation.}

\item{penalized}{A matrix of penalized covariates.}

\item{unpenalized}{A matrix of additional unpenalized covariates.}

\item{lambda.seq}{a sequence of non-negative value to be used as tuning
parameter for L1}

\item{alpha}{The elastic net mixing parameter, a number between 0 and 1.
alpha=0 would give pure ridge; alpha=1 gives lasso. Pure ridge penalty is never obtained in this implementation since alpha must be positive.}

\item{B}{A single positive number for the number of subsamples.}

\item{parallel}{Logical. Should the computation be parallelized?}

\item{standardize}{Should the covariates be standardized, a logical value.}

\item{event}{If response is a factor, the level that
should be considered a success in the logistic regression.}
}
\value{
A list with a  numeric vector \code{Pistab}
giving selection probabilities for each penalized covariate, and
a sequence \code{lambda.seq} used.
}
\description{
Performs stability selection for conditional logistic regression models with
L1 and L2 penalty.
}
\examples{
 set.seed(123)

# simulate covariates (pure noise in two blocks of 20 and 80 variables)
X <- cbind(matrix(rnorm(4000, 0, 1), ncol = 20), matrix(rnorm(16000, 2, 0.6), ncol = 80))

# stratum membership
stratum <- sort(rep(1:100, 2))

# the response
Y <- rep(c(1, 0), 100)

# default L1 penalty
lambda <- find.default.lambda(response = Y,
                                   penalized = X,
                                   stratum = stratum)

# perform stability selection
\donttest{
stable1 <- stable.clr(response = Y, penalized = X, stratum = stratum,
                         lambda.seq = lambda)}



}
\seealso{
\code{\link{stable.clr.g}} for stability selection
in penalized conditional logistic regression with multiple penalties for block structured covariates.
}
