# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Computes the time grid from the auxiliary vector U.
#' @aliases getGrid
#' @param U vector of change point indicators
#' @param ftgrid vector with the finest time grid (distinct observed failure times)
#' @return the time grid associated with the auxiliary vector U.
#'
getGrid <- function(U, ftgrid) {
    .Call(`_peppm_getGrid`, U, ftgrid)
}

#' Runs the Gibbs sampler
#' @aliases gibbs
#' @param U0 vector of change point indicators
#' @param ftgrid vector of indexes of distinct failure times
#' @param time vector of observed failure times.
#' @param status vector of failure indicators
#' @param a_rates shape parameter of the gamma distribution (prior for failure rates).
#' @param b_rates scale parameter of the gamma distribution (prior for failure rates).
#' @param cohesion type of prior cohesion (1 to 4).
#' @param a_beta shape1 parameter of the beta distribution (prior for p - cohesion 4).
#' @param b_beta shape2 parameter of the beta distribution (prior for p - cohesion 4).
#' @param nburnin number of iterations to be discarded.
#' @param npost desired posterior sample size
#' @param nlag number of jumps to eliminate autocorrelation of the chain.
#' @return posterior sample
#' 
gibbs <- function(U0, ftgrid, time, status, a_rates, b_rates, cohesion, a_beta, b_beta, npost, nburnin, nlag) {
    .Call(`_peppm_gibbs`, U0, ftgrid, time, status, a_rates, b_rates, cohesion, a_beta, b_beta, npost, nburnin, nlag)
}

