% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peppm.R
\name{peppm}
\alias{peppm}
\title{Piecewise Exponential Product Partition Model}
\usage{
peppm(
  time,
  status,
  a_rates = 1,
  b_rates = 1,
  cohesion = 1,
  a_beta = 1,
  b_beta = 1,
  nburnin = 10000,
  npost = 20000,
  nlag = 10
)
}
\arguments{
\item{time}{vector of observed failure times.}

\item{status}{vector of failure indicators}

\item{a_rates}{shape parameter of the gamma distribution (prior for failure rates).}

\item{b_rates}{scale parameter of the gamma distribution (prior for failure rates).}

\item{cohesion}{type of prior cohesion (1 to 4).}

\item{a_beta}{shape1 parameter of the beta distribution (prior for p - cohesion 4).}

\item{b_beta}{shape2 parameter of the beta distribution (prior for p - cohesion 4).}

\item{nburnin}{number of iterations to be discarded.}

\item{npost}{desired posterior sample size}

\item{nlag}{number of jumps to eliminate autocorrelation of the chain.}
}
\value{
Posterior sample of the number of intervals, failure rates, the auxiliary vector U, and the logarithm of the prior predictive distribution (log data factor).
}
\description{
Piecewise Exponential Product Partition Model
}
\examples{
# Small chain used here due to time constraints. 
data(telecom)

# Prior cohesion 1:
fit1 <- with(telecom, peppm(time, status, cohesion=1, nburnin = 0, nlag = 1, npost = 100))
# Prior cohesion 2:
fit2 <- with(telecom, peppm(time, status, cohesion=2, nburnin = 0, nlag = 1, npost = 100))
# Prior cohesion 3:
fit3 <- with(telecom, peppm(time, status, cohesion=3, nburnin = 0, nlag = 1, npost = 100))
# Prior cohesion 4:
fit4 <- with(telecom, peppm(time, status, cohesion=4, nburnin = 0, nlag = 1, npost = 100))  
   
}
