% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{getSubsample}
\alias{getSubsample}
\alias{getSubsample,Project,character,character-method}
\title{Extract subsamples}
\usage{
getSubsample(.Object, sampleName, subsampleName)

\S4method{getSubsample}{Project,character,character}(.Object, sampleName, subsampleName)
}
\arguments{
\item{.Object}{An object of Project class}

\item{sampleName}{character the name of the sample}

\item{subsampleName}{character the name of the subsample}
}
\value{
data.table one row data table with the subsample associated metadata
}
\description{
This method extracts the subsamples
}
\section{Methods (by class)}{
\itemize{
\item \code{getSubsample(
  .Object = Project,
  sampleName = character,
  subsampleName = character
)}: extracts the subsamples from the \code{"\linkS4class{Project}"} object

}}
\examples{
projectConfig = system.file(
"extdata",
"example_peps-master",
"example_subtable1",
"project_config.yaml",
package = "pepr"
)
p = Project(projectConfig)
sampleName = "frog_1"
subsampleName = "sub_a"
getSubsample(p, sampleName, subsampleName)
}
