% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_PN.R
\name{create_PN}
\alias{create_PN}
\title{Create Petri Net}
\usage{
create_PN(places, transitions, flows)
}
\arguments{
\item{places}{\code{data.frame} or \code{tibble} of places, with columns id and label. Both columns should be characters.}

\item{transitions}{\code{data.frame} or \code{tibble} of transitions, with columns id and label. Both columns should be characters.}

\item{flows}{\code{data.frame} or \code{tibble} of flows, with columns named "from" and "to", referring to ids of places and transitions. Both columns should be characters.}
}
\value{
A \code{\link{petrinet}}
}
\description{
Function to create a \code{\link{petrinet}} by specifying places, transitions and flows.
}
\examples{
library(dplyr)
create_PN(tibble(id = "p1", label = "place_1"),
			tibble(id = "t1", label = "transition_1"),
			tibble(from = "t1",to = "p1"))

}
