% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-stopbound-pred.r
\name{stopbound_pred}
\alias{stopbound_pred}
\title{The stopping boundaries based on Lee and Liu's criterion}
\usage{
stopbound_pred(theta, type, nmax, alpha_e, beta_e, p_s, theta_t)
}
\arguments{
\item{theta}{the cutoff probability: typically, \eqn{\theta = [0.95, 0.99]} for superiority, \eqn{\theta = [0.01, 0.05]} for futility.}

\item{type}{type of boundaries: "superiority" or "futility".}

\item{nmax}{the maximum number of patients treated by the experimental drug.}

\item{alpha_e}{the hyperparameter (shape1) of the Beta prior for the experimental drug.}

\item{beta_e}{the hyperparameter (shape2) of the Beta prior for the experimental drug.}

\item{p_s}{the the response rate for the standard drug.}

\item{theta_t}{the prespecified target probability; tipically, \eqn{\theta_T = [0.85, 0.95]}.}
}
\value{
\item{boundset}{the boundaries set: \eqn{U_n} or \eqn{L_n}}
}
\description{
The stopping boundaries based on Lee and Liu's criterion.
}
\examples{
stopbound_pred(0.05, "futility", 40, 0.6, 1.4, 0.3, 0.85)
stopbound_pred(0.05, "futility", 30, 0.4, 1.6, 0.2, 0.85)
stopbound_pred(0.95, "superiority", 40, 0.6, 1.4, 0.3, 0.85)
}
\references{
Lee, J. J., Liu, D. D. (2008).
A predictive probability design for phase II cancer clinical trials.
\emph{Clinical Trials} \strong{5}: 93-106.

Yin, G. (2012).
\emph{Clinical Trial Design: Bayesian and Frequentist Adaptive Methods.}
New York: Wiley.
}
