% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{run_iovsearch}
\alias{run_iovsearch}
\title{run_iovsearch}
\usage{
run_iovsearch(
  model,
  results,
  column = "OCC",
  list_of_parameters = NULL,
  rank_type = "bic",
  cutoff = NULL,
  distribution = "same-as-iiv",
  strictness = "minimization_successful or (rounding_errors and sigdigs>=0.1)",
  E = NULL,
  ...
)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{results}{(ModelfitResults) Results for model}

\item{column}{(str) Name of column in dataset to use as occasion column (default is 'OCC')}

\item{list_of_parameters}{(array(str or array(str)) (optional)) List of parameters to test IOV on, if none all parameters with IIV will be tested (default)}

\item{rank_type}{(str) Which ranking type should be used. Default is BIC.}

\item{cutoff}{(numeric (optional)) Cutoff for which value of the ranking type that is considered significant. Default
is NULL (all models will be ranked)}

\item{distribution}{(str) Which distribution added IOVs should have (default is same-as-iiv)}

\item{strictness}{(str (optional)) Strictness criteria}

\item{E}{(numeric or str (optional)) Expected number of predictors (used for mBIC). Must be set when using mBI}

\item{...}{Arguments to pass to tool}
}
\value{
(IOVSearchResults) IOVSearch tool result object
}
\description{
Run IOVsearch tool. For more details, see :ref:\code{iovsearch}.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
results <- load_example_modelfit_results("pheno")
run_iovsearch(model=model, results=results, column='OCC')
}

}
