% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_lower_bounds}
\alias{set_lower_bounds}
\title{set_lower_bounds}
\usage{
set_lower_bounds(model, bounds, strict = TRUE)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{bounds}{(list(str=numeric)) A list of parameter bounds for parameters to change}

\item{strict}{(logical) Whether all parameters in input need to exist in the model. Default is TRUE}
}
\value{
(Model) Pharmpy model object
}
\description{
Set parameter lower bounds
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- set_lower_bounds(model, {'POP_CL': -10})
model$parameters['POP_CL']
}
}
\seealso{
set_upper_bounds : Set parameter upper bounds

unconstrain_parameters : Remove all constraints of parameters
}
