\name{data.combine.timeseries}
\alias{data.combine.timeseries}

\title{Create combined timeseries}
\description{Creates combined timeseries out of the dataset by using clusters of stations.}
\usage{data.combine.timeseries(dataset, clusters, 
			silent=FALSE, out2File=FALSE, 
			minimalClusterSize=5)}
\arguments{
  \item{dataset}{A dataset created by \code{\link{data.extract}} containing the information that 
			should be used to generate the combined timeseries.}
  \item{clusters}{A list of station clusters generated by \code{\link{data.combine.clusters}}.}
  \item{silent}{A boolean value determining wether the function should generate output messages or not.}
  \item{out2File}{A boolean value determining wether the output will be stored in log-files.}
  \item{minimalClusterSize}{An integer value determining the minimal number of stations in a 
				cluster to be included in combining process.}
 }
\details{The combined timeseries are created by using the function \code{\link[pheno]{pheno.lad.fit}} of package \sQuote{pheno}. This process eliminates outliers and smooths the data.}
\value{A dataset containing the combined timeseries as a data.frame with same columns like a data.frame created by \code{\link{data.extract}}.}
\references{Schaber J., Badeck F. (2002). Evaluation of methods for the combination of phenological time series and outlier detection. Tree Physiology, 22:973-982}
\author{Daniel Doktor, Maximilian Lange}
\seealso{\code{\link[pheno]{pheno.lad.fit}}, \code{\link{data.extract}}, 
	\code{\link{data.combine.stationNet}}, \code{\link{data.combine.clusters}}}

\examples{
  ## load extracted observations as created by 'data.extract'
  data(extractedObs)

  ## create station net
  stations.net <- data.combine.stationNet(extractedObs, 
				range=5000, alt.range=50, silent=FALSE, 
				out2File=FALSE)

  ## search clusters in station net
  clusters <- data.combine.clusters(extractedObs, 
			stations.net, shuffle=TRUE, tries=3, 
			silent=FALSE, out2File=FALSE)

  ## combine timeseries
  data.combined <- data.combine.timeseries(extractedObs, 
				clusters, out2File=FALSE)
}

