% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-uses.r
\docType{data}
\name{lamp_uses}
\alias{lamp_uses}
\alias{photography_lamps}
\alias{plant_grow_lamps}
\alias{germicidal_lamps}
\alias{flashlights}
\title{Spectral data for Lamps designed for specific uses}
\format{
A vector of character strings.

An object of class \code{character} of length 8.

An object of class \code{character} of length 9.

An object of class \code{character} of length 1.

An object of class \code{character} of length 6.
}
\usage{
lamp_uses

photography_lamps

plant_grow_lamps

germicidal_lamps

flashlights
}
\description{
Names of members of the \code{\link{lamps.mspct}} collection of spectra
grouped by intended use.
}
\details{
These vectors can be used to extract subsets of spectra from
  \code{lamps.mspct}. The set of names is not exhaustive.  One additional
  vector, \code{lamp_uses} contains the naming given to intended specific
  lamp uses. Photography and video lamps are listed together in the vector
  \code{photography_lamps}.
}
\note{
In the case of LED-based lamps we include here only ready built
  commercially available lamps. In some cases assembled from multiple
  discrete LEDs, possible of mixed types and spectral output. For emission
  spectra for LEDs available as electronic components please see
  \code{\link[photobiologyLEDs]{photobiologyLEDs-package}}.
}
\examples{
plant_grow_lamps
photography_lamps

# select lamps for photography
lamps.mspct[photography_lamps]

}
\seealso{
\code{\link{lamps.mspct}}

Other indexing vectors of names: 
\code{\link{lamp_brands}},
\code{\link{lamp_colors}},
\code{\link{lamp_types}}
}
\concept{indexing vectors of names}
\concept{lamps by intended use}
\keyword{datasets}
