% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.peaks.r
\name{find_wls}
\alias{find_wls}
\title{Find wavelength values in a spectrum}
\usage{
find_wls(
  x,
  target = NULL,
  col.name.x = NULL,
  col.name = NULL,
  .fun = `<=`,
  interpolate = FALSE,
  idfactor = length(target) > 1,
  na.rm = FALSE
)
}
\arguments{
\item{x}{an R object}

\item{target}{numeric or character. A numeric value indicates the spectral
quantity value for which wavelengths are to be searched. A character
representing a number is converted to a number. A character value
representing a number followed by a function name, will be also accepted
and decoded, such that \code{"0.1max"} is interpreted as targetting one
tenthof the maximum value in a column. The character strings "half.maximum"
and "HM" are synonyms for "0.5max" while "half.range" and "HR" are synonyms
for "0.5range". These synonyms are converted to the cannonical form before
saving them to the returned value.}

\item{col.name.x}{character The name of the column in which to the
independent variable is stored. Defaults to "w.length" for objects of class
\code{"generic_spct"} or derived.}

\item{col.name}{character The name of the column in which to search for the
target value.}

\item{.fun}{function A binary comparison function or operator.}

\item{interpolate}{logical Indicating whether the nearest wavelength value in
\code{x} should be returned or a value calculated by linear interpolation
between wavelength values stradling the target.}

\item{idfactor}{logical or character Generates an index column of factor
type. If \code{idfactor = TRUE} then the column is auto named target.idx.
Alternatively the column name can be directly passed as argument to
\code{idfactor} as a character string.}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before searching for the target.}
}
\value{
A spectrum object of the same class as \code{x} with fewer rows,
  possibly even no rows. If \code{FALSE} is passed to \code{interpolate} a
  subset of \code{x} is returned, otherwise a new object of the same class
  containing interpolated wavelenths for the \code{target} value is returned.
}
\description{
Find wavelength values corresponding to a target y value in any spectrum. The
name of the column of the spectral data to be used to match the target needs
to be passed as argument unless the spectrum contains a single numerical
variable in addition to "w.length".
}
\note{
This function is used internally by method \code{wls_at_target()}, and
  these methods should be preferred in user code and scripts.
}
\examples{
find_wls(white_led.source_spct)
find_wls(white_led.source_spct, target = "0.5max")
find_wls(white_led.source_spct, target = 0.4)
find_wls(white_led.source_spct, target = 0.4, interpolate = TRUE)
find_wls(white_led.source_spct, target = c(0.3, 0.4))
find_wls(white_led.source_spct, target = c(0.3, 0.4), idfactor = "target")
find_wls(white_led.source_spct, target = c(0.3, 0.4), idfactor = TRUE)
find_wls(white_led.source_spct, target = "0.5max")
find_wls(white_led.source_spct, target = "0.05max")
find_wls(white_led.source_spct, target = "0.5range")

led.df <- as.data.frame(white_led.source_spct)
find_wls(led.df)
find_wls(led.df, col.name = "s.e.irrad", col.name.x = "w.length")
find_wls(led.df, col.name = "s.e.irrad", col.name.x = "w.length",
         target = 0.4)
find_wls(led.df, col.name = "s.e.irrad", col.name.x = "w.length",
         target = c(0.3, 0.4))
find_wls(led.df, col.name = "s.e.irrad", col.name.x = "w.length",
         target = 0.4, idfactor = "target")

}
