% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InheritanceReporter.R
\name{InheritanceReporter}
\alias{InheritanceReporter}
\title{Class Inheritance Reporter}
\description{
This reporter takes a package and traces the class inheritance
structure. Currently the following object-oriented systems are supported:
\itemize{
    \item{S4 Classes}
    \item{Reference Classes (sometimes informally called "R5")}
    \item{R6 Classes}
}
S3 classes are not supported, as their inheritance is defined on an ad hoc
basis per object and not formally by class definitions.
}
\details{
Note the following details about class naming:
  \itemize{
      \item{Reference Classes : The name passed as \code{Class} in
      \code{\link[methods:ReferenceClasses]{setRefClass}} is used as the node
      name by this reporter. This is the class name that is used when
      specifying inheritance. The generator object returned by
      \code{\link[methods:ReferenceClasses]{setRefClass}} does not have to be
      assigned and can have a different name.}
      \item{R6 Classes : The name of the generator object in the package
      namespace is used as the node name by this reporter. The generator
      object returned by \code{\link[R6:R6Class]{R6::R6Class}} is what is
      used when specifying inheritance. The name passed as \code{classname}
      passed to \code{\link[R6:R6Class]{R6::R6Class}} can be a different name
      or even NULL.}
 }

  For more info about R's built-in object-oriented systems, check out the
  relevant chapter in \href{http://adv-r.had.co.nz/OO-essentials.html}{Hadley
  Wickham's \emph{Advanced R}}. For more info about R6, check out their
  \href{https://r6.r-lib.org/index.html}{docs website} or the chapter in
  \href{https://adv-r.hadley.nz/r6.html}{\emph{Advanced R}'s second edition}.
}
\seealso{
Other Network Reporters: 
\code{\link{DependencyReporter}},
\code{\link{FunctionReporter}}

Other Package Reporters: 
\code{\link{DependencyReporter}},
\code{\link{FunctionReporter}},
\code{\link{SummaryReporter}}
}
\concept{Network Reporters}
\concept{Package Reporters}
\concept{Reporters}
\section{Super classes}{
\code{\link[pkgnet:AbstractPackageReporter]{pkgnet::AbstractPackageReporter}} -> \code{\link[pkgnet:AbstractGraphReporter]{pkgnet::AbstractGraphReporter}} -> \code{InheritanceReporter}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{report_markdown_path}}{(character string) path to R Markdown template for this reporter. Read-only.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-InheritanceReporter-clone}{\code{InheritanceReporter$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractPackageReporter" data-id="set_package"><a href='../../pkgnet/html/AbstractPackageReporter.html#method-AbstractPackageReporter-set_package'><code>pkgnet::AbstractPackageReporter$set_package()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractGraphReporter" data-id="calculate_default_measures"><a href='../../pkgnet/html/AbstractGraphReporter.html#method-AbstractGraphReporter-calculate_default_measures'><code>pkgnet::AbstractGraphReporter$calculate_default_measures()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractGraphReporter" data-id="get_summary_view"><a href='../../pkgnet/html/AbstractGraphReporter.html#method-AbstractGraphReporter-get_summary_view'><code>pkgnet::AbstractGraphReporter$get_summary_view()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InheritanceReporter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-InheritanceReporter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InheritanceReporter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
