% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gantt.R
\name{read.gantt}
\alias{read.gantt}
\title{Read a gantt data file}
\usage{
read.gantt(file, debug = FALSE)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file
to load.}

\item{debug}{boolean, set to \code{TRUE} to print debugging information.}
}
\value{
A \linkS4class{gantt} object, which is a data frame containing
\code{description} (a character description of the task), \code{"start"}
(the task's start time), \code{"end"} (the task's end time),
\code{"progress"} (a number giving the percent progress on this item, or
\code{NA} if none given), and \code{needed.by} (a number giving the
indices of other tasks that rely on this task, or \code{NA} if none given).
}
\description{
Read a data file containing gantt information.
The data format is strict, and deviations from it may lead to error messages
that are difficult to understand; see \dQuote{Details}.
}
\details{
The first line is a header, and must contain the words \code{Key},
\code{Description}, \code{Start}, \code{End}, \code{Done}, and
\code{NeededBy}, written exactly in this way, with commas separating the
words.  (Blanks are ignored in this line.)

Additional lines indicate the details of each of several sub-projects, in
comma-separated items, as follows:
\itemize{
\item A key for the task.  These must be distinct, and are
typically just the numbers 1, 2, 3, etc.
\item A description of the task.  (This may not contain commas!)
\item The start time for the task, in ISO 8601 format (\code{YYYY-MM-DD} or
\verb{YYYY-MM-DD hh:mm:ss}).
\item The end time for the task, in the same format as the starting time. If
an end time equals the corresponding start time, no rectangle will be drawn
for the activity, and this gives a way to make headings (see example 7
for \code{\link[=plot,gantt-method]{plot,gantt-method()}}).
\item A number indicating the percentage of this task that has been
completed to date.
\item A space-separated optional list of numbers that indicate the keys of
other tasks that depend on this one.  This list is ignored in the present
version of \code{\link[=read.gantt]{read.gantt()}}.
}
}
\section{Sample data file}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{Key, Description,                 Start,        End, Done, NeededBy
  1, Assemble equipment,     2008-01-01, 2008-03-28, 90
  2, Test methods,           2008-02-28, 2008-03-28, 30
  3, Field sampling,         2008-04-01, 2008-08-14, 0
  4, Analyse field data,     2008-06-30, 2008-11-14, 0
  5, Write methods chapter,  2008-08-14, 2008-11-14, 0
  6, Write results chapter,  2008-10-14, 2009-01-15, 0
  7, Write other chapters,   2008-12-10, 2009-02-28, 0
  8, Committee reads thesis, 2009-02-28, 2009-03-14, 0
  9, Revise thesis,          2009-03-15, 2009-03-30, 0
 10, Thesis on display,      2009-04-01, 2009-04-15, 0
 11, Defend thesis,          2009-04-16, 2009-04-17, 0
 12, Finalize thesis,        2009-04-18, 2009-05-07, 0
}\if{html}{\out{</div>}}
}

\examples{
library(plan)
filename <- system.file("extdata", "gantt.dat", package="plan")
g <- read.gantt(filename)
summary(g)
plot(g)

}
\seealso{
Other things related to gantt data: 
\code{\link{as.gantt}()},
\code{\link{gantt-class}},
\code{\link{ganttAddTask}()},
\code{\link{gantt}},
\code{\link{plot,gantt-method}},
\code{\link{summary,gantt-method}}
}
\author{
Dan Kelley
}
\concept{things related to gantt data}
