% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_plate.R
\name{fill_plate}
\alias{fill_plate}
\title{Fill in missing wells}
\usage{
fill_plate(df, well, plate = 96)
}
\arguments{
\item{df}{dataframe}

\item{well}{Column containing well identifiers i.e "A01"}

\item{plate}{Number of wells in complete plate (96, 384 or 1536)}
}
\value{
dataframe
}
\description{
Fills in missing wells with rows of NA values. Useful for any functions
that require a complete plate such as `b_score`.
}
\examples{
vals <- rnorm(96) ; wells <- num_to_well(1:96)
df <- data.frame(wells, vals)
df_missing <- df[-c(1:10), ]
fill_plate(df_missing, "wells")
}
