% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_moderators.R
\name{plot_moderator_d_density}
\alias{plot_moderator_d_density}
\title{Plot the Conditional Average Treatment Effect conditional on a discrete moderator}
\usage{
plot_moderator_d_density(
  .model,
  moderator,
  .alpha = 0.7,
  facet = FALSE,
  .ncol = 1
)
}
\arguments{
\item{.model}{a model produced by `bartCause::bartc()`}

\item{moderator}{the moderator as a vector}

\item{.alpha}{transparency value [0, 1]}

\item{facet}{TRUE/FALSE. Create panel plots of each moderator level?}

\item{.ncol}{number of columns to use when faceting}
}
\value{
ggplot object
}
\description{
Plot the Conditional Average Treatment Effect split by a discrete moderating variable. This plot will provide a visual test of moderation by discrete variables.
}
\examples{
\donttest{
data(lalonde)
confounders <- c('age', 'educ', 'black', 'hisp', 'married', 'nodegr')
model_results <- bartCause::bartc(
 response = lalonde[['re78']],
 treatment = lalonde[['treat']],
 confounders = as.matrix(lalonde[, confounders]),
 estimand = 'ate',
 commonSuprule = 'none'
)
plot_moderator_d_density(model_results, lalonde$educ)
}
}
\author{
George Perrett
}
