% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcli.r
\name{plotcli}
\alias{plotcli}
\title{plotcli R6 Class}
\description{
plotcli R6 Class

plotcli R6 Class
}
\details{
This class provides a set of methods to create and customize command-line plots using R6.
It supports various plot types, such as scatter, line, bar, and box plots, and allows
customization of plot elements, such as title, axis labels, ticks, and legend.
}
\section{Usage}{

\preformatted{
plotcli <- plotcli$new()
plotcli$add_data(data)
plotcli$print_plot()
}
}

\section{Methods}{

\describe{
  \item{initialize()}{Initializes the PlotCLI object with parameters.}
  \item{initialize_plot_matrix()}{Initializes the plot matrix with the plot canvas.}
  \item{print()}{Default print method for PlotCLI object.}
  \item{add_row()}{Adds a single row to the plot matrix.}
  \item{add_col()}{Adds a single column to the plot matrix.}
  \item{add_borders()}{Adds borders around the plot canvas.}
  \item{add_row_col_index()}{Adds row and column index to the plot matrix.}
  \item{add_title()}{Adds a title to the plot matrix.}
  \item{add_y_ticks()}{Adds y-axis tick labels to the plot matrix.}
  \item{add_y_label()}{Adds a y-axis label to the plot matrix.}
  \item{add_x_ticks()}{Adds x-axis tick labels to the plot matrix.}
  \item{add_x_label()}{Adds an x-axis label to the plot matrix.}
  \item{add_legend()}{Adds a legend to the plot matrix.}
  \item{add_data()}{Adds data to the object.}
  \item{get_min_max()}{Gets minimum and maximum values for x and y.}
  \item{remove_out_of_range_data()}{Removes out of range data points if xlim and ylim were given.}
  \item{draw_scatter_plot()}{Draws a scatter plot on the plot canvas.}
  \item{draw_line_plot()}{Draws a line plot on the plot canvas.}
  \item{draw_barplot()}{Draws a bar plot on the plot canvas.}
  \item{draw_barplot_braille()}{Draws a bar plot with braille characters on the plot canvas.}
  \item{draw_boxplot()}{Draws a box plot on the plot canvas.}
  \item{print_plot()}{Assembles all plot elements and prints the plot to the console.}
}
}

\examples{
# Create a new plotcli object
plotcli <- plotcli$new()

# Add data for a scatter plot
plotcli$add_data(list(x = 1:10, y = rnorm(10), type = "scatter", color = "red"))

# Print the plot
plotcli$print_plot()

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{plot_width}}{The width of the plot}

\item{\code{plot_height}}{The height of the plot}

\item{\code{plot_canvas}}{The canvas for drawing the plot}

\item{\code{plot_matrix}}{The matrix containing the entire plot, including borders, labels, and title}

\item{\code{data}}{A list containing the data sets to be plotted}

\item{\code{title}}{The title of the plot}

\item{\code{x_label}}{The label for the x-axis}

\item{\code{y_label}}{The label for the y-axis}

\item{\code{ylim}}{The limits for the y-axis}

\item{\code{xlim}}{The limits for the x-axis}

\item{\code{x_min}}{The minimum value of the x-axis}

\item{\code{x_max}}{The maximum value of the x-axis}

\item{\code{y_min}}{The minimum value of the y-axis}

\item{\code{y_max}}{The maximum value of the y-axis}

\item{\code{plot_matrix_canvas_row_start}}{The starting row of the plot canvas within the plot matrix}

\item{\code{plot_matrix_canvas_col_start}}{The starting column of the plot canvas within the plot matrix}

\item{\code{is_boxplot}}{A logical value indicating if the plot is a boxplot}

\item{\code{draw_legend}}{A logical value indicating if the legend should be drawn}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-plotcli-new}{\code{plotcli$new()}}
\item \href{#method-plotcli-initialize_plot_matrix}{\code{plotcli$initialize_plot_matrix()}}
\item \href{#method-plotcli-print}{\code{plotcli$print()}}
\item \href{#method-plotcli-add_row}{\code{plotcli$add_row()}}
\item \href{#method-plotcli-add_col}{\code{plotcli$add_col()}}
\item \href{#method-plotcli-add_borders}{\code{plotcli$add_borders()}}
\item \href{#method-plotcli-add_row_col_index}{\code{plotcli$add_row_col_index()}}
\item \href{#method-plotcli-add_title}{\code{plotcli$add_title()}}
\item \href{#method-plotcli-add_y_ticks}{\code{plotcli$add_y_ticks()}}
\item \href{#method-plotcli-add_y_label}{\code{plotcli$add_y_label()}}
\item \href{#method-plotcli-add_x_ticks}{\code{plotcli$add_x_ticks()}}
\item \href{#method-plotcli-add_x_label}{\code{plotcli$add_x_label()}}
\item \href{#method-plotcli-add_legend}{\code{plotcli$add_legend()}}
\item \href{#method-plotcli-add_data}{\code{plotcli$add_data()}}
\item \href{#method-plotcli-get_min_max}{\code{plotcli$get_min_max()}}
\item \href{#method-plotcli-remove_out_of_range_data}{\code{plotcli$remove_out_of_range_data()}}
\item \href{#method-plotcli-draw_scatter_plot}{\code{plotcli$draw_scatter_plot()}}
\item \href{#method-plotcli-draw_line_plot}{\code{plotcli$draw_line_plot()}}
\item \href{#method-plotcli-draw_barplot}{\code{plotcli$draw_barplot()}}
\item \href{#method-plotcli-draw_barplot_braille}{\code{plotcli$draw_barplot_braille()}}
\item \href{#method-plotcli-draw_boxplot}{\code{plotcli$draw_boxplot()}}
\item \href{#method-plotcli-draw_colors}{\code{plotcli$draw_colors()}}
\item \href{#method-plotcli-draw_plot}{\code{plotcli$draw_plot()}}
\item \href{#method-plotcli-make_plot_matrix}{\code{plotcli$make_plot_matrix()}}
\item \href{#method-plotcli-export_plot_matrix}{\code{plotcli$export_plot_matrix()}}
\item \href{#method-plotcli-print_plot}{\code{plotcli$print_plot()}}
\item \href{#method-plotcli-merge}{\code{plotcli$merge()}}
\item \href{#method-plotcli-clone}{\code{plotcli$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-new"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-new}{}}}
\subsection{Method \code{new()}}{
Initialize object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$new(
  plot_width = 60,
  plot_height = 20,
  x_label = "x",
  y_label = "y",
  ylim = NULL,
  xlim = NULL,
  title = NULL,
  is_boxplot = FALSE,
  draw_legend = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_width}}{integer, width of the plot canvas}

\item{\code{plot_height}}{integer, height of the plot canvas}

\item{\code{x_label}}{character, label for the x-axis}

\item{\code{y_label}}{character, label for the y-axis}

\item{\code{ylim}}{numeric vector, limits for the y-axis}

\item{\code{xlim}}{numeric vector, limits for the x-axis}

\item{\code{title}}{character, title of the plot}

\item{\code{is_boxplot}}{logical, whether the plot is a boxplot}

\item{\code{draw_legend}}{logical, whether to draw the legend
This function initializes the plot matrix based on the plot canvas.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-initialize_plot_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-initialize_plot_matrix}{}}}
\subsection{Method \code{initialize_plot_matrix()}}{
Initialize the plot matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$initialize_plot_matrix()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_width}}{The width of the plot}

\item{\code{plot_height}}{The height of the plot}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A plot matrix object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-print"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-print}{}}}
\subsection{Method \code{print()}}{
Default print method for plotcli object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments passed to the print method}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The plotcli object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-add_row"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-add_row}{}}}
\subsection{Method \code{add_row()}}{
Add a single row to the plot matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$add_row(bottom = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bottom}}{logical, if TRUE, add row to the bottom of the matrix, otherwise add to the top (default: FALSE)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-add_col"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-add_col}{}}}
\subsection{Method \code{add_col()}}{
Add a single column to the plot matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$add_col()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-add_borders"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-add_borders}{}}}
\subsection{Method \code{add_borders()}}{
Add borders to the plot matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$add_borders()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-add_row_col_index"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-add_row_col_index}{}}}
\subsection{Method \code{add_row_col_index()}}{
Add row and column index to the plot matrix
Add title to the plot matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$add_row_col_index()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-add_title"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-add_title}{}}}
\subsection{Method \code{add_title()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$add_title()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{character, title of the plot
Add y-ticks label to the plot matrix}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-add_y_ticks"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-add_y_ticks}{}}}
\subsection{Method \code{add_y_ticks()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$add_y_ticks(n_ticks = 5)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_ticks}}{numeric, number of ticks
Add y-axis label to the plot matrix}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-add_y_label"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-add_y_label}{}}}
\subsection{Method \code{add_y_label()}}{
Add a y-axis label to the plot matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$add_y_label(y_label = self$y_label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{y_label}}{character, the y-axis label to be added
Add x-ticks label to the plot matrix}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-add_x_ticks"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-add_x_ticks}{}}}
\subsection{Method \code{add_x_ticks()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$add_x_ticks(n_ticks = 5)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_ticks}}{numeric, number of ticks
Add x-axis label to the plot matrix}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-add_x_label"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-add_x_label}{}}}
\subsection{Method \code{add_x_label()}}{
Add x-axis label to the plot matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$add_x_label(x_label = self$x_label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x_label}}{x label
Add legend to the plot matrix}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-add_legend"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-add_legend}{}}}
\subsection{Method \code{add_legend()}}{
Add legend to the plot matrix
Add data to the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$add_legend()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-add_data"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-add_data}{}}}
\subsection{Method \code{add_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$add_data(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{list, list with elements: x, y, type, color, braille, name
Get minimum and maximum values for x and y}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-get_min_max"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-get_min_max}{}}}
\subsection{Method \code{get_min_max()}}{
Calculate the minimum and maximum values for x and y
Function to remove out of range data points if xlim and ylim were given
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$get_min_max()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-remove_out_of_range_data"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-remove_out_of_range_data}{}}}
\subsection{Method \code{remove_out_of_range_data()}}{
Remove data points that are outside the specified xlim and ylim
Draw a scatter plot to the plot canvas.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$remove_out_of_range_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-draw_scatter_plot"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-draw_scatter_plot}{}}}
\subsection{Method \code{draw_scatter_plot()}}{
Draw a scatter plot of the specified data set on the plot canvas.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$draw_scatter_plot(set_idx)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set_idx}}{numeric, the data element index to be drawn
Draw a line plot to the plot canvas.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-draw_line_plot"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-draw_line_plot}{}}}
\subsection{Method \code{draw_line_plot()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$draw_line_plot(set_idx)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set_idx}}{numeric, the data element index to be drawn
Draw a barplot to the plot canvas.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-draw_barplot"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-draw_barplot}{}}}
\subsection{Method \code{draw_barplot()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$draw_barplot(set_idx)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set_idx}}{numeric, the data element index to be drawn
Draw a barplot to the plot canvas with braille characters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-draw_barplot_braille"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-draw_barplot_braille}{}}}
\subsection{Method \code{draw_barplot_braille()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$draw_barplot_braille(set_idx)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set_idx}}{numeric, the data element index to be drawn
Draw a boxplot to the plot canvas.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-draw_boxplot"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-draw_boxplot}{}}}
\subsection{Method \code{draw_boxplot()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$draw_boxplot(set_idx)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set_idx}}{numeric, the data element index to be drawn
Draw colors to the canvas}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-draw_colors"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-draw_colors}{}}}
\subsection{Method \code{draw_colors()}}{
In the draw_ functions we have been keeping track of the locations of the colored matrix elements.
These are now being colored.
Draw the different plots types from all data elements to the canvas
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$draw_colors()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-draw_plot"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-draw_plot}{}}}
\subsection{Method \code{draw_plot()}}{
This function iterates through all data elements and calls the appropriate draw_ function
based on the plot type (scatter, line, boxplot, or barplot).
Make plot matrix: assembles all plot elements (canvas + borders + title + axes + legend)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$draw_plot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-make_plot_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-make_plot_matrix}{}}}
\subsection{Method \code{make_plot_matrix()}}{
This function assembles all plot elements (canvas + borders + title + axes + legend)
and creates the final plot matrix.
Export plot matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$make_plot_matrix()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-export_plot_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-export_plot_matrix}{}}}
\subsection{Method \code{export_plot_matrix()}}{
This function exports the plot matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$export_plot_matrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The plot matrix.
Main plotting function: assembles all plot elements (canvas + borders + title + axes + legend) and prints the plot
by 'cat'ing the plot matrix to the console.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-print_plot"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-print_plot}{}}}
\subsection{Method \code{print_plot()}}{
This function assembles all plot elements (canvas + borders + title + axes + legend) and
prints the final plot by 'cat'ing the plot matrix to the console.
Merge two plotcli objects

This method combines the data from two plotcli objects into a single plotcli object.
It takes the maximum of the plot_width and plot_height, combines the titles, and sets
the xlim and ylim to the minimum and maximum values of both objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$print_plot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-merge"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-merge}{}}}
\subsection{Method \code{merge()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$merge(other)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{other}}{A plotcli object to be merged with the current object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new plotcli object containing the combined data from both objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotcli-clone"></a>}}
\if{latex}{\out{\hypertarget{method-plotcli-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotcli$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
