% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REP.R
\name{rep_pls}
\alias{rep_pls}
\title{Regularized elimination procedure in PLS}
\usage{
rep_pls(y, X, ncomp = 5, ratio = 0.75, VIP.threshold = 0.5, N = 3)
}
\arguments{
\item{y}{vector of response values (\code{numeric} or \code{factor}).}

\item{X}{numeric predictor \code{matrix}.}

\item{ncomp}{integer number of components (default = 5).}

\item{ratio}{the proportion of the samples to use for calibration (default = 0.75).}

\item{VIP.threshold}{thresholding to remove non-important variables (default = 0.5).}

\item{N}{number of samples in the selection matrix (default = 3).}
}
\value{
Returns a vector of variable numbers corresponding to the model 
having lowest prediction error.
}
\description{
A regularized variable elimination procedure for parsimonious
variable selection, where also a stepwise elimination is carried out
}
\details{
A stability based variable selection procedure is adopted, where the
samples have been split randomly into a predefined number of training and test sets.
For each split, g, the following stepwise procedure is adopted to select the variables.
This implementation does not follow the original publication exactly, but
it opens for both regression and classification.
}
\examples{
data(gasoline, package = "pls")
\dontrun{
with( gasoline, rep_pls(octane, NIR) )
}

}
\references{
T. Mehmood, H. Martens, S. Sæbø, J. Warringer, L. Snipen, A partial 
least squares based algorithm for parsimonious variable selection, Algorithms for
Molecular Biology 6 (2011).
}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{shaving}}, 
\code{\link{stpls}}, \code{\link{truncation}},
\code{\link{bve_pls}}, \code{\link{ga_pls}}, \code{\link{ipw_pls}}, \code{\link{mcuve_pls}},
\code{\link{rep_pls}}, \code{\link{spa_pls}},
\code{\link{lda_from_pls}}, \code{\link{lda_from_pls_cv}}, \code{\link{setDA}}.
}
\author{
Tahir Mehmood, Kristian Hovde Liland, Solve Sæbø.
}
