% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loess_cal.R
\name{loess_cal}
\alias{loess_cal}
\title{calibration curve via \code{loess}}
\usage{
loess_cal(p, y, x, xp, save_data = TRUE, save_mod = TRUE, pw = FALSE)
}
\arguments{
\item{p}{predicted probabilities}

\item{y}{binary outcome}

\item{x}{predictor (could be transformation of \code{p})}

\item{xp}{values for plotting (same scale as \code{x})}

\item{save_data}{whether to save y, p, x, xp in the returned object}

\item{save_mod}{whether to save the model in the returned object}

\item{pw}{save pointwise standard errors for plotting}
}
\value{
list of class \code{loess_cal}
}
\description{
calibration curve via \code{loess}
}
\examples{
library(pmcalibration)
# simulate some data
n <- 500
dat <- sim_dat(N = n, a1 = .5, a3 = .2)

# predictions
p <- with(dat, invlogit(.5 + x1 + x2 + x1*x2*.1))

loess_cal(y = dat$y, p = p, x = p, xp = NULL)
}
\keyword{internal}
