% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{utils_load_directories_csv}
\alias{utils_load_directories_csv}
\title{Load directory "csv" file(s) into memory}
\usage{
utils_load_directories_csv(
  type = c("general", "trades"),
  directories,
  path,
  verbose
)
}
\arguments{
\item{type}{A character string: "general" or "trades". Refers to the type of
directory to shall be loaded.}

\item{directories}{A character string vector providing the name(s) of the
directory(/ies) to load.}

\item{path}{A character string specifying the path to the folder where the
directory(/ies) live as ".csv" file(s).}

\item{verbose}{Whether the function should be executed silently (\code{FALSE}) or
not (\code{TRUE}).}
}
\value{
A dataframe.
}
\description{
Loads specified directory "csv" file(s) into memory. Stacks individual
directories into a single dataframe and further passes the output down to
\code{\link{utils_format_directory_raw}} for initial formatting.
}
\examples{
\dontrun{
  utils_load_directories_csv(
    "general", "1861-1862",
    "home/projects/glasgow-entrepreneurs/data/general-directories", FALSE
  )
}

}
