% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R, R/subset.R
\name{subset-method}
\alias{subset-method}
\alias{subset}
\alias{subset,corpus-method}
\alias{subset,character-method}
\alias{subset,subcorpus-method}
\alias{subset,remote_corpus-method}
\alias{subset,subcorpus_bundle-method}
\title{Subsetting corpora and subcorpora}
\usage{
\S4method{subset}{corpus}(x, subset, regex = FALSE, verbose = FALSE, ...)

\S4method{subset}{character}(x, ...)

\S4method{subset}{subcorpus}(x, subset, verbose = FALSE, ...)

\S4method{subset}{remote_corpus}(x, subset)

\S4method{subset}{subcorpus_bundle}(x, ..., iterate = FALSE, verbose = TRUE, progress = FALSE, mc = NULL)
}
\arguments{
\item{x}{A \code{corpus} or \code{subcorpus} object. A corpus may also specified by a
length-one \code{character} vector.}

\item{subset}{A \code{logical} expression indicating elements or rows to
keep. The expression may be unevaluated (using \code{quote()} or
\code{bquote()}).}

\item{regex}{A \code{logical} value. If \code{TRUE}, values for s-attributes
defined using the three dots (...) are interpreted as regular expressions
and passed into a \code{grep} call for subsetting a table with the regions
and values of structural attributes. If \code{FALSE} (the default), values
for s-attributes must match exactly.}

\item{verbose}{A \code{logical} value, whether to show progress messages.}

\item{...}{An expression that will be used to create a subcorpus from
s-attributes.}

\item{iterate}{A \code{logical} value, if \code{TRUE}, process very single object of
\code{x} individually.}

\item{progress}{A \code{logical} value, whether to display progress bar.}

\item{mc}{An \code{integer} value, number of cores to use. If \code{NULL} (default),
no multithreading.}
}
\value{
A \code{subcorpus} object. If the expression provided by argument \code{subset}
includes undefined s-attributes, a warning is issued and the return value
is \code{NULL}.
}
\description{
The structural attributes of a corpus (s-attributes) can be used
to generate subcorpora (i.e. a \code{subcorpus} class object) by applying the
\code{subset}-method. To obtain a \code{subcorpus}, the \code{subset}-method can be
applied on a corpus represented by a \code{corpus} object, a length-one
\code{character} vector (as a shortcut), and on a \code{subcorpus} object.
}
\details{
The default approach for subsetting a \code{subcorpus_bundle} is to
temporarily merge objects into a single \code{subcorpus}, perform \code{subset()},
and restore \code{subcorpus_bundle} by splitting on the s-attribute of the input
\code{subcorpus_bundle}. This approach may have unintended results, if \code{x} has
been generated using complex criteria. This may be the case for instance,
if \code{x} resulted from \code{as.speeches()}. In this scenario, set argument
\code{iterate} to \code{TRUE} to iterate over objects in bundle one-by-one.
}
\examples{
use("polmineR")

# examples for standard and non-standard evaluation
a <- corpus("GERMAPARLMINI")

# subsetting a corpus object using non-standard evaluation
sc <- subset(a, speaker == "Angela Dorothea Merkel")
sc <- subset(a, speaker == "Angela Dorothea Merkel" & date == "2009-10-28")
sc <- subset(a, grepl("Merkel", speaker))
sc <- subset(a, grepl("Merkel", speaker) & date == "2009-10-28")

# subsetting corpus specified by character vector
sc <- subset("GERMAPARLMINI", grepl("Merkel", speaker))
sc <- subset("GERMAPARLMINI", speaker == "Angela Dorothea Merkel")
sc <- subset("GERMAPARLMINI", speaker == "Angela Dorothea Merkel" & date == "2009-10-28")
sc <- subset("GERMAPARLMINI", grepl("Merkel", speaker) & date == "2009-10-28")

# subsetting a corpus using the (old) logic of the partition-method
sc <- subset(a, speaker = "Angela Dorothea Merkel")
sc <- subset(a, speaker = "Angela Dorothea Merkel", date = "2009-10-28")
sc <- subset(a, speaker = "Merkel", regex = TRUE)
sc <- subset(a, speaker = c("Merkel", "Kauder"), regex = TRUE)
sc <- subset(a, speaker = "Merkel", date = "2009-10-28", regex = TRUE)

# providing the value for s-attribute as a variable
who <- "Volker Kauder"
sc <- subset(a, quote(speaker == !!who))

# quoting and quosures necessary when programming against subset
# note how variable who needs to be handled
gparl <- corpus("GERMAPARLMINI")
subcorpora <- lapply(
  c("Angela Dorothea Merkel", "Volker Kauder", "Ronald Pofalla"),
  function(who) subset(gparl, speaker == !!who)
)

# subset a subcorpus_bundle
merkel <- corpus("GERMAPARLMINI") \%>\%
  split(s_attribute = "protocol_date") \%>\%
  subset(speaker == "Angela Dorothea Merkel")

# iterate over objects in bundle one by one 
sp <- corpus("GERMAPARLMINI") \%>\%
  as.speeches(
    s_attribute_name = "speaker",
    s_attribute_date = "protocol_date",
    progress = FALSE
  ) \%>\%
  subset(interjection == "speech", iterate = TRUE, progress = FALSE)
}
\seealso{
The methods applicable for the \code{subcorpus} object resulting from
subsetting a corpus or subcorpus are described in the documentation of the
\verb{\link{subcorpus-class}}. Note that the \code{subset}-method can also be applied
to \code{\link{textstat-class}} objects (and objects inheriting from this
class).
}
