% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_simult.R
\encoding{UTF-8}
\name{ind_simult}
\alias{ind_simult}
\title{Assess polypharmacy based on the daily simultaneous consumption of medications}
\usage{
ind_simult(
  processed_tab,
  individual_stats = c("mean", "min", "median", "max"),
  stats = c("mean", "sd", "min", "p5", "p10", "p25", "median", "p75", "p90", "p95",
    "max"),
  calendar = FALSE,
  cores = parallel::detectCores()
)
}
\arguments{
\item{processed_tab}{Table of individual drug treatments over the study period. Created by \code{\link{data_process}} function.}

\item{individual_stats}{Descriptive statistics of daily consumption over the study period to calculate for every individual. See \emph{Details} for possible values.}

\item{stats}{Cohort descriptive statistics to calculate on the polypharmacy indicator. See \emph{Details} for possible values.}

\item{calendar}{\code{TRUE} or \code{FALSE}. Create a table of the number of drugs consumed everyday by every individual (\code{FALSE} by default).}

\item{cores}{The number of CPU cores to use. See \code{\link[parallel]{detectCores}}.}
}
\value{
\code{list}:
\itemize{
\item \code{indic}: \code{data.table} indicating each \code{stats} (columns) for each \code{individual_stats} (rows).
\item \code{stats_id}: \code{data.table} indicating each \code{individual_stats} for each individuals (all cohort).
\item \code{min_conso}: \code{data.table} indicating each \code{stats} for the number of days where an individual consume at least \code{X} drugs.
\item \code{calendar}: If \code{calendar=TRUE}, \code{data.table} indicating the number of drugs consumed for each day (only for individuals who has at least 1 day with 1 drug consumption).
}
}
\description{
Calculates various metrics measuring the number of distinct medications consumed daily for every individual of the study cohort over the study period and provides cohort descriptive statistics on those metrics.
}
\details{
\strong{individual_stats & stats:} Possible values are
\itemize{
\item \code{'mean'}, \code{'min'}, \code{'median'}, \code{'max'}, \code{'sd'};
\item \code{'pX'} where \emph{X} is an integer value in ]0, 100];
\item \code{'q1'}=\code{'p25'}, \code{'q2'}=\code{'p50'}=\code{'median'}, \code{q3}=\code{'p75'}.
}
}
\examples{
rx1 <- data.frame(id = c(1, 1, 2),
                  code = c("A", "B", "A"),
                  date = c("2000-01-01", "2000-01-04", "2000-01-08"),
                  duration = c(5, 7, 5))
cohort1 <- data.frame(id = as.numeric(1:3),
                      age = c(45, 12, 89),
                      sex = c("F", "F", "M"))
rx_proc1 <- data_process(Rx_deliv = rx1, Rx_id = "id", Rx_drug_code = "code",
                         Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
                         Cohort = cohort1, Cohort_id = "id",
                         study_start = "2000-01-01", study_end = "2000-01-15",
                         cores = 1)
dt_ind_simult <- ind_simult(rx_proc1, calendar = TRUE, cores = 1)
}
