% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{errorABC}
\alias{errorABC}
\title{Calculate cross-validation prediction error of parameter estimation}
\usage{
errorABC(true, estimated)
}
\arguments{
\item{true}{is a matrix where each row corresponds to the true parameter
values of a given simulation and each column to a different parameter.
These parameters where used as the pseudo-observed targets in the
simulation study.}

\item{estimated}{is a matrix with the estimated parameter values. Each row
corresponds to the estimate of the true parameter values present in the
corresponding row of the \code{true} matrix. And each column should correspond
to a different parameter.}
}
\value{
a numeric vector with the prediction error for each parameter. If
column names are present in the input matrices, then this vector will also
be named with the parameter names.
}
\description{
This function calculates the prediction error between estimates obtained
after a leave-one-out cross validation for ABC and the true parameter values.
}
\details{
The prediction error is calculated as \code{sum((E-T)^2) / (nval * var(T))},
where T is the true parameter value, E is the estimated parameter value, and
nval is the number of points where the true and predicted values were
compared.
}
\keyword{internal}
