% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortality_projection.R
\name{mortality_projection}
\alias{mortality_projection}
\title{mortality_projection}
\usage{
mortality_projection(
  mortality_rates_path,
  total_population_path,
  omega_age,
  horizon,
  first_year_projection,
  ...
)
}
\arguments{
\item{mortality_rates_path}{character. Path to Mortality rates in a .txt file.}

\item{total_population_path}{character. Path to Populations in a .txt file.}

\item{omega_age}{numeric. Maximum age.}

\item{horizon}{numeric. The forecast horizon.}

\item{first_year_projection}{numeric. Year for the base population.}

\item{...}{additional arguments to be passed to \code{\link[forecast]{Arima}}.}
}
\value{
\code{mortality_projection} returns an object of class \code{fmforecast} with with both female and male mortality projections and the components of \code{\link[demography]{forecast.lca}}.
}
\description{
Forecasting mortality rates.
}
\examples{

\donttest{
\dontrun{
library(dplyr)

data(CR_mortality_rates_1950_2011)

#CR_mortality_rates_1950_2011 \%>\%
#write.table(.,
#file = "CR_mortality_rates_1950_2011.txt",
#sep = "\t",
#row.names = FALSE,
#col.names = TRUE,
#quote = FALSE)


data(CR_populations_1950_2011)

#CR_populations_1950_2011 \%>\%
#write.table(.,
#file = "CR_populations_1950_2011.txt",
#sep = "\t",
#row.names = FALSE,
#col.names = TRUE,
#quote = FALSE)

#result <- mortality_projection(mortality_rates_path = "CR_mortality_rates_1950_2011.txt",
#total_population_path = "CR_populations_1950_2011.txt",
#omega_age = 115, first_year_projection = 2011, horizon = 2150)

}
}

}
\author{
Cesar Gamboa-Sanabria
}
