% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{alpha}
\alias{alpha}
\title{Set new alpha of a portfolio.model}
\usage{
alpha(model, alpha)
}
\arguments{
\item{model}{the portfolio.model to be changed}

\item{alpha}{the value alpha (between 0 and 1)}
}
\value{
the adapted portfolio.model
}
\description{
\code{alpha} sets a new alpha for VaR and Expected Shortfall
}
\examples{
data(sp100w17av30s)
model <- optimal.portfolio(scenario.set)
cvar95 <- optimal.portfolio(objective(model, "expected.shortfall"))
cvar90 <- optimal.portfolio(alpha(cvar95, 0.1))

}
\author{
Ronald Hochreiter, \email{ronald@algorithmic.finance}
}
