% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/et.R
\name{poso_replace_et}
\alias{poso_replace_et}
\title{Update a model with events from a new rxode2 event table}
\usage{
poso_replace_et(
  target_model = NULL,
  prior_model = NULL,
  event_table = NULL,
  interpolation = "locf"
)
}
\arguments{
\item{target_model}{Solved rxode2 object. A model generated by one of
posologyr's estimation functions.}

\item{prior_model}{A \code{posologyr} prior population model.}

\item{event_table}{An rxode2 event table.}

\item{interpolation}{Character string. Specifies the interpolation method to
be used for covariates. Choices are "locf" for last observation carried
forward, "nocb" for next observation carried backward, "midpoint", or
"linear".}
}
\value{
A solved rxode2 object, updated with the event table provided.
}
\description{
Update a model with events from a new rxode2 event table, while accounting
for and interpolating any covariates or inter-occasion variability.
}
\examples{
# model
mod_run001 <- function() {
  ini({
    THETA_Cl <- 4.0
    THETA_Vc <- 70.0
    THETA_Ka <- 1.0
    ETA_Cl ~ 0.2
    ETA_Vc ~ 0.2
    ETA_Ka ~ 0.2
    prop.sd <- sqrt(0.05)
  })
  model({
    TVCl <- THETA_Cl
    TVVc <- THETA_Vc
    TVKa <- THETA_Ka

    Cl <- TVCl*exp(ETA_Cl)
    Vc <- TVVc*exp(ETA_Vc)
    Ka <- TVKa*exp(ETA_Ka)

    K20 <- Cl/Vc
    Cc <- centr/Vc

    d/dt(depot) = -Ka*depot
    d/dt(centr) = Ka*depot - K20*centr
    Cc ~ prop(prop.sd)
  })
}
# df_patient01: event table for Patient01, following a 30 minutes intravenous
# infusion
df_patient01 <- data.frame(ID=1,
                        TIME=c(0.0,1.0,14.0),
                        DV=c(NA,25.0,5.5),
                        AMT=c(2000,0,0),
                        EVID=c(1,0,0),
                        DUR=c(0.5,NA,NA))
# estimate the prior distribution of population parameters
pop_model <- poso_simu_pop(dat=df_patient01,prior_model=mod_run001,n_simul=100)
# create a new rxode2 event table from the initial dataset
new_et <- rxode2::as.et(df_patient01)
new_et$add_sampling(seq(14,15,by=0.1))
# update the model with the new event table
poso_replace_et(pop_model$model,mod_run001,event_table=new_et)

}
