% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reenumNodes.R
\name{enum2cladewise}
\alias{enum2cladewise}
\title{Function to modify the node enumeration in rooted binary trees}
\usage{
enum2cladewise(phy, root = NULL)
}
\arguments{
\item{phy}{A rooted binary tree of class \code{phylo}.}

\item{root}{Integer value (default = NULL) that should only be specified if
the root is known precisely (not necessary, but speeds up computation).}
}
\value{
\code{enum2cladewise}  A single tree of class \code{phylo} is
returned with cladewise node enumeration.
}
\description{
\code{enum2cladewise} - Changes the node enumeration to cladewise
enumeration, i.e., starting from the root we follow the rule:\cr
Go to the left child; if that does not exist or was already visited go (up
again and) to the right child.\cr
The nodes in the rooted binary tree can be nearly arbitrarily enumerated
(distinct nodes should have distinct values and the
values should be positive, i.e., >0).
}
\examples{
# Example with cladewise enumeration:
phy_alreadycladew <- list(edge = matrix(c(6,7, 7,8, 8,1, 8,2,
                                          7,9, 9,3, 9,4, 6,5),
                                 byrow = TRUE, ncol = 2),
                          tip.label = rep(" ",5), Nnode = 4)
attr(phy_alreadycladew, "class") <- "phylo"
enum2cladewise(phy_alreadycladew, root = 6)$edge
ape::plot.phylo(phy_alreadycladew)
# Example with other node enumeration:
phy_example <- list(edge = matrix(c(1,55, 55,12, 12,2, 12,10, 55,9,
                                    9,13, 9,60, 1,3),
                                  byrow = TRUE, ncol = 2),
                    tip.label = rep(" ",5), Nnode = 4,
                    edge.length = rep(1, 8))
attr(phy_example, "class") <- "phylo"
# The reenumeration works with and without specifying the root:
enum2cladewise(phy_example, root = 1)$edge
ape::plot.phylo(enum2cladewise(phy_example))
}
