% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{predict.ppgam}
\alias{predict.ppgam}
\title{Predictions from a fitted \code{ppgam} object}
\usage{
\method{predict}{ppgam}(object, newdata, type = "link", se.fit = FALSE, ...)
}
\arguments{
\item{object}{a fitted \code{ppgam} object}

\item{newdata}{a data frame}

\item{type}{a character string giving the type of prediction sought; see Details. Defaults to \code{"link"}}

\item{se.fit}{a logical: should estimated standard errors be returned? Defaults to \code{FALSE}}

\item{...}{passed to \code{mgcv::predict()}}
}
\value{
A data frame or list of predictions
}
\description{
Predictions from a fitted \code{ppgam} object
}
\details{
This calls \link[mgcv]{predict.gam} and gives predictions of the intensity function of 
the Poisson process on the original scale if \code{type = "response"}, on log 
scale if \code{type = "link"} (default), and of the design matrix if 
\code{type = "lpmatrix"}.
}
\examples{

# Times of landfalling US hurricanes
data(USlandfall)

# convert dates to years, as a continuous variable
year <- as.integer(format(USlandfall$date, "\%Y"))
day <- as.integer(format(USlandfall$date, "\%j"))
USlandfall$year <- year + pmin(day / 365, 1)
hits <- subset(USlandfall, landfall == 1)

# this creates nodes in the default way
m1 <- ppgam( ~ s(year), hits)
predict(m1)
predict(m1, type = "response")
predict(m1, type = "lpmatrix")
predict(m1, newdata = data.frame(year = c(2000, 2001)))
predict(m1, se.fit = TRUE)

}
\references{
Youngman, B. D., & Economou, T. (2017). Generalised additive point process models for natural 
hazard occurrence. Environmetrics, 28(4), e2444.
}
\seealso{
\link[mgcv]{predict.gam}
}
