% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_spectralslice.R
\name{draw_spectralslice}
\alias{draw_spectralslice}
\title{Draw spectral slice}
\usage{
draw_spectralslice(
  sound,
  time,
  channel = 1,
  freqRange = NULL,
  energyRange = 60,
  log = FALSE,
  method = "fft",
  multitaper_args = NULL,
  windowLength = 0.005,
  windowShape = "Gaussian",
  color = "black",
  lineWidth = 1,
  freq_axisLabel = "Frequency (Hz)",
  energy_axisLabel = "Sound pressure level (dB/Hz)",
  mainTitle = "",
  mainTitleAlignment = 0,
  highlight = NULL,
  draw_lines = NULL,
  draw_rectangle = NULL,
  draw_arrow = NULL,
  annotate = NULL,
  ...
)
}
\arguments{
\item{sound}{String giving the file name of a sound file with the .wav
extension.}

\item{time}{Time (in seconds) specifying the center of the window from which
to estimate spectrum.}

\item{channel}{Numeric giving the channel that should be used to
generate the spectrogram. Default is \code{1}.}

\item{freqRange}{Vector of two numbers giving the frequency range to be
used for plotting spectrograms. Default is \code{NULL}, in which case the whole
spectrum is plotted using the Nyquist frequency for the upper limit.}

\item{energyRange}{Either numeric or vector of two numbers used to specify
the y-axis range in units of dB/Hz. If a single number is passed, this is
interpreted as the desired dynamic range of the y-axis. If a vector of
two numbers is passed, these are used to exactly delimit the y-axis.
Default is \code{60}, i.e. a dynamic range of 60 dB/Hz relative to the global
maximum.}

\item{log}{Logical; should the frequency range be log scaled? Default is
\code{FALSE}.}

\item{method}{String specifying the spectral estimation. Default is \code{fft}
(for the fast discrete Fourier transform). The only other option is
\code{multitaper}, in which case \link[multitaper:spec.mtm]{multitaper::spec.mtm} is used to generate the
spectrum.}

\item{multitaper_args}{Optional named list of arguments passed on to
\link[multitaper:spec.mtm]{multitaper::spec.mtm} if \code{method='multitaper'}.}

\item{windowLength}{Window length in seconds for generating spectra.
Default is \code{0.005}.}

\item{windowShape}{String giving the name of the window shape to be
applied to the signal when generating spectrograms. Default is \code{Gaussian};
other options are \code{square}, \code{Hamming}, \code{Bartlett}, \code{Hanning}, \code{Blackman}, or
\code{Kaiser}.Note that the Gaussian window function provided by the \code{phonTools}
package and used for this function does not have the same properties as the
Gaussian window function used for spectral estimation in Praat.}

\item{color}{String giving the name of the color to be used for plotting
the spectrum. Default is \code{'black'}.}

\item{lineWidth}{Number giving the line width to use for plotting
the spectrum. Default is \code{1}.}

\item{freq_axisLabel}{String giving the name of the label to print along the
x-axis. Default is \code{Frequency (Hz)}.}

\item{energy_axisLabel}{String giving the name of the label to print along
the y-axis. Default is \verb{Sound pressure level (dB/Hz)}.}

\item{mainTitle}{String giving a title to print at the top of the plot.
The default is an empty string, i.e. no title.}

\item{mainTitleAlignment}{Number indicating the vertical alignment of the
plot title, where \code{0} (default) indicates left-alignment, \code{1} indicates
right-alignment, \code{0.5} indicates central alignment, etc, following the
conventions of the \code{adj} argument of \link[graphics:mtext]{graphics::mtext}.}

\item{highlight}{Named list giving parameters for differential highlighting
of part of the plot based on the frequency domain. This list should contain
information about which parts of the plot to highlight, done with the
\code{start} and \code{end} arguments which must be numbers or numeric vectors.
Further contains the optional arguments \code{color}
(a string), \code{drawSize} (numeric), and \code{background}
(a string specifying a background color).}

\item{draw_lines}{Use for drawing straight lines. Takes
an argument of type \code{list} which should contain arguments to pass on to
\link[graphics:abline]{graphics::abline}. Should have a named argument \code{h} for horizontal lines,
or \code{v} for vertical lines, or \code{a},\code{b} for the intercept and slope of the
line otherwise. Alternatively a nested list can be passed if more (sets of)
lines should be drawn. Default is \code{NULL}.}

\item{draw_rectangle}{Use for drawing rectangles. Should be a named
list containing arguments to pass on to \link[graphics:rect]{graphics::rect}. Can also be
multiple nested lists, if more rectangles should be drawn.}

\item{draw_arrow}{Use for drawing arrows on plot components. Should be a
named list containing arguments to pass on to \link[graphics:arrows]{graphics::arrows}.
Can also be multiple nested lists, if more rectangles should be drawn.}

\item{annotate}{Use for annotating plot components. Should be a
named list containing arguments to pass on to\link[graphics:text]{graphics::text}.
Can also be multiple nested lists, if more annotations should be added.}

\item{...}{Further global plotting arguments passed on to \code{par()}.}
}
\value{
No return value, produces a figure.
}
\description{
Generate and plot spectral slice from window around a specified time point
of a sound file.
}
\examples{
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')
draw_spectralslice(soundFile, time = 0.75)
}
