% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_r_squared.R
\name{estimate_r_squared}
\alias{estimate_r_squared}
\title{Estimates R^2 (r-squared) values for a range of number of profiles}
\usage{
estimate_r_squared(
  df,
  ...,
  to_center = FALSE,
  to_scale = FALSE,
  distance_metric = "squared_euclidean",
  linkage = "complete",
  lower_bound = 2,
  upper_bound = 9,
  r_squared_table = TRUE
)
}
\arguments{
\item{df}{with two or more columns with continuous variables}

\item{...}{unquoted variable names separated by commas}

\item{to_center}{(TRUE or FALSE) for whether to center the raw data with M = 0}

\item{to_scale}{Boolean (TRUE or FALSE) for whether to scale the raw data with SD = 1}

\item{distance_metric}{Distance metric to use for hierarchical clustering; "squared_euclidean" is default but more options are available (see ?hclust)}

\item{linkage}{Linkage method to use for hierarchical clustering; "complete" is default but more options are available (see ?dist)}

\item{lower_bound}{the smallest number of profiles in the range of number of profiles to explore; defaults to 2}

\item{upper_bound}{the largest number of profiles in the range of number of profiles to explore; defaults to 9}

\item{r_squared_table}{if TRUE (default), then a table, rather than a plot, is returned; defaults to FALSE}
}
\value{
A list containing a ggplot2 object and a tibble for the R^2 values
}
\description{
Estimates R^2 (r-squared) values for a range of number of profiles
}
\details{
Returns ggplot2 plot of cluster centroids
}
