% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{predict_gender}
\alias{predict_gender}
\title{Find the gender of a first name}
\usage{
predict_gender(name, probability = TRUE)
}
\arguments{
\item{name}{String or vector of strings of  the first name that you want to know the gender of.}

\item{probability}{If TRUE (default) will provide columns for each race with the probability
that the first name is of that gender If FALSE, will only return the name,
the match-name from the SSA data, and the most likely gender.}
}
\value{
A data.frame with three or nine columns: The first column has the name as inputted,
the second column has the cleaned up name (no spaces or punctuation, all
lowercase), the third column tells the likely gender of the first name
(if there are multiple genders with the same probability of a match, it will be
a string with each race separated by a comma). If the
parameter probability is false, these three columns are all that is returned.
Otherwise, columns 4-5 tell the specific probability that the surname is female
or male.
}
\description{
The surname data comes from the United States Social Security Administration (SSA).
This data has the number of people with that name that are identified as female
or male so the probability female/male is the proportion of all people with that
name that are female/male. SSA data is available annually from 1880-2019, this
aggregates all years together.
}
\examples{
predict_gender("tyrion")

predict_gender(c("harry", "ron", "hermione", "DEAN", "NEVILLE", "Cho"))
predict_gender("franklin", probability = FALSE)
predict_gender("jacob", probability = FALSE)
predict_gender("jacob", probability = TRUE)
}
