% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs.R
\name{prepost_gibbs}
\alias{prepost_gibbs}
\title{Run Gibbs sampler for the random moderator placement design}
\usage{
prepost_gibbs(
  formula,
  data,
  prepost,
  moderator,
  covariates,
  iter = 1000,
  thin = 1,
  burn = 0,
  offset = 0,
  monotonicity = TRUE,
  stable = TRUE,
  saturated = TRUE,
  priors
)
}
\arguments{
\item{formula}{A formula with syntax \code{y ~ t}, where \code{y} is the
(unquoted) name of the outcome and \code{t} is the (unquoted) name of the treatment.}

\item{data}{A data.frame containing variables in the formula, moderator, and covariates arguments.}

\item{prepost}{A one-sided formula with syntax \code{~ z}, where \code{z} is the
indicator variable for whether the moderator was measured  pre- or post-treatment.}

\item{moderator}{A one-sided formuala with syntax \code{~ d}, where \code{d}
is the (unquoted) name of the  moderator variable for the CATE.}

\item{covariates}{A one-sided formula with syntax \code{~ x1 + x2},
where the right-hand side variables signify which covariates the
Gibbs will use to try and narrow the bounds.}

\item{iter}{Integer indicating the number of iterations for the
Gibbs sampler.}

\item{thin}{Integer indicating how often the Gibbs sampler should
save a draw.}

\item{burn}{Integer indicating how many iterations should be
performed before saving draws in the Gibbs sampler.}

\item{offset}{A numeric value indicating the center of the prior distribution for the covariate coefficients.}

\item{monotonicity}{A logical signifying whether the model assumes monotonicity.}

\item{stable}{A logical signifying whether the model assumes that the
the pre vs post indicator does not affect the moderator under the
control condition for treatment.}

\item{saturated}{A logical indicating whether the coefficients on
the covariates are allowed to vary by the principal strata.}

\item{priors}{A list object containing the priors for the Gibbs
sampler. Priors include beta.precision, psi.precision, alpha,
y.alpha, and y.beta.}
}
\value{
A list object containing Gibbs posterior quantities of interest and parameters.
}
\description{
Run Gibbs sampler for the random moderator placement design
}
\examples{
data(land_experiment)
prepost_gibbs(
  support ~ treat_comb,
  data = land_experiment,
  moderator = ~ land_insecure,
  prepost = ~ prepost,
  covariates = ~ educ + age,
  iter = 50
)
}
