% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs.R
\name{prepost_gibbs_nocovar}
\alias{prepost_gibbs_nocovar}
\title{Run Gibbs sampler without covariates}
\usage{
prepost_gibbs_nocovar(
  formula,
  data,
  prepost,
  moderator,
  iter = 1000,
  thin = 1,
  burn = 0,
  monotonicity = TRUE,
  stable = TRUE,
  priors,
  predictive = FALSE
)
}
\arguments{
\item{formula}{A formula with syntax \code{y ~ t}, where \code{y} is the name of the  outcome variable and \code{t} is the name of the treatment.}

\item{data}{A data frame containin the variables in the formula.}

\item{prepost}{A one-sided formula with syntax ~ z, where z is the indicator variable for whether the moderator was measured pre- or post-treatment.}

\item{moderator}{A formuala with syntax ~ d, where d is the moderator variable for the CATE.}

\item{iter}{Numeric, number of iterations for the Gibbs}

\item{thin}{Numeric, thinning parameter for the Gibbs}

\item{burn}{Numeric, burn in rate for the Gibbs}

\item{monotonicity}{A logical signifying whether Gibbs assumes monotonicity.}

\item{stable}{A logical signifying whether Gibbs assumes stability.}

\item{priors}{A list object containing the priors for the Gibbs sampler. Priors include beta.precision, psi.precision, alpha, y.alpha, and y.beta.}

\item{predictive}{A logical indicator for whether to return prior predictive draws (\code{TRUE}) or posterior draws (\code{FALSE}, default).}
}
\value{
A list object containing Gibbs posterior quantities of interest and parameters.
}
\description{
Run Gibbs sampler without covariates
}
\examples{
data(land_experiment)
prepost_gibbs_nocovar(
  support ~ treat_comb,
  data = land_experiment,
  moderator = ~ land_insecure,
  prepost = ~ prepost,
  iter = 50
)
}
